package imagerecog

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EvaluateCertificateQuality invokes the imagerecog.EvaluateCertificateQuality API synchronously
func (client *Client) EvaluateCertificateQuality(request *EvaluateCertificateQualityRequest) (response *EvaluateCertificateQualityResponse, err error) {
	response = CreateEvaluateCertificateQualityResponse()
	err = client.DoAction(request, response)
	return
}

// EvaluateCertificateQualityWithChan invokes the imagerecog.EvaluateCertificateQuality API asynchronously
func (client *Client) EvaluateCertificateQualityWithChan(request *EvaluateCertificateQualityRequest) (<-chan *EvaluateCertificateQualityResponse, <-chan error) {
	responseChan := make(chan *EvaluateCertificateQualityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EvaluateCertificateQuality(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EvaluateCertificateQualityWithCallback invokes the imagerecog.EvaluateCertificateQuality API asynchronously
func (client *Client) EvaluateCertificateQualityWithCallback(request *EvaluateCertificateQualityRequest, callback func(response *EvaluateCertificateQualityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EvaluateCertificateQualityResponse
		var err error
		defer close(result)
		response, err = client.EvaluateCertificateQuality(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EvaluateCertificateQualityRequest is the request struct for api EvaluateCertificateQuality
type EvaluateCertificateQualityRequest struct {
	*requests.RpcRequest
	Type     string `position:"Body" name:"Type"`
	ImageURL string `position:"Body" name:"ImageURL"`
}

// EvaluateCertificateQualityResponse is the response struct for api EvaluateCertificateQuality
type EvaluateCertificateQualityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateEvaluateCertificateQualityRequest creates a request to invoke EvaluateCertificateQuality API
func CreateEvaluateCertificateQualityRequest() (request *EvaluateCertificateQualityRequest) {
	request = &EvaluateCertificateQualityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imagerecog", "2019-09-30", "EvaluateCertificateQuality", "imagerecog", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEvaluateCertificateQualityResponse creates a response to parse from EvaluateCertificateQuality response
func CreateEvaluateCertificateQualityResponse() (response *EvaluateCertificateQualityResponse) {
	response = &EvaluateCertificateQualityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
