package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitNodeLocalConfigAddingTask invokes the linkwan.SubmitNodeLocalConfigAddingTask API synchronously
func (client *Client) SubmitNodeLocalConfigAddingTask(request *SubmitNodeLocalConfigAddingTaskRequest) (response *SubmitNodeLocalConfigAddingTaskResponse, err error) {
	response = CreateSubmitNodeLocalConfigAddingTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitNodeLocalConfigAddingTaskWithChan invokes the linkwan.SubmitNodeLocalConfigAddingTask API asynchronously
func (client *Client) SubmitNodeLocalConfigAddingTaskWithChan(request *SubmitNodeLocalConfigAddingTaskRequest) (<-chan *SubmitNodeLocalConfigAddingTaskResponse, <-chan error) {
	responseChan := make(chan *SubmitNodeLocalConfigAddingTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitNodeLocalConfigAddingTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitNodeLocalConfigAddingTaskWithCallback invokes the linkwan.SubmitNodeLocalConfigAddingTask API asynchronously
func (client *Client) SubmitNodeLocalConfigAddingTaskWithCallback(request *SubmitNodeLocalConfigAddingTaskRequest, callback func(response *SubmitNodeLocalConfigAddingTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitNodeLocalConfigAddingTaskResponse
		var err error
		defer close(result)
		response, err = client.SubmitNodeLocalConfigAddingTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitNodeLocalConfigAddingTaskRequest is the request struct for api SubmitNodeLocalConfigAddingTask
type SubmitNodeLocalConfigAddingTaskRequest struct {
	*requests.RpcRequest
	Freq        requests.Integer `position:"Query" name:"Freq"`
	Datr        requests.Integer `position:"Query" name:"Datr"`
	D2dKey      string           `position:"Query" name:"D2dKey"`
	DevEui      string           `position:"Query" name:"DevEui"`
	D2dAddr     string           `position:"Query" name:"D2dAddr"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// SubmitNodeLocalConfigAddingTaskResponse is the response struct for api SubmitNodeLocalConfigAddingTask
type SubmitNodeLocalConfigAddingTaskResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         int64  `json:"Data" xml:"Data"`
}

// CreateSubmitNodeLocalConfigAddingTaskRequest creates a request to invoke SubmitNodeLocalConfigAddingTask API
func CreateSubmitNodeLocalConfigAddingTaskRequest() (request *SubmitNodeLocalConfigAddingTaskRequest) {
	request = &SubmitNodeLocalConfigAddingTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "SubmitNodeLocalConfigAddingTask", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitNodeLocalConfigAddingTaskResponse creates a response to parse from SubmitNodeLocalConfigAddingTask response
func CreateSubmitNodeLocalConfigAddingTaskResponse() (response *SubmitNodeLocalConfigAddingTaskResponse) {
	response = &SubmitNodeLocalConfigAddingTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
