package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsGroupConsumerUpdate invokes the ons.OnsGroupConsumerUpdate API synchronously
func (client *Client) OnsGroupConsumerUpdate(request *OnsGroupConsumerUpdateRequest) (response *OnsGroupConsumerUpdateResponse, err error) {
	response = CreateOnsGroupConsumerUpdateResponse()
	err = client.DoAction(request, response)
	return
}

// OnsGroupConsumerUpdateWithChan invokes the ons.OnsGroupConsumerUpdate API asynchronously
func (client *Client) OnsGroupConsumerUpdateWithChan(request *OnsGroupConsumerUpdateRequest) (<-chan *OnsGroupConsumerUpdateResponse, <-chan error) {
	responseChan := make(chan *OnsGroupConsumerUpdateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsGroupConsumerUpdate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsGroupConsumerUpdateWithCallback invokes the ons.OnsGroupConsumerUpdate API asynchronously
func (client *Client) OnsGroupConsumerUpdateWithCallback(request *OnsGroupConsumerUpdateRequest, callback func(response *OnsGroupConsumerUpdateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsGroupConsumerUpdateResponse
		var err error
		defer close(result)
		response, err = client.OnsGroupConsumerUpdate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsGroupConsumerUpdateRequest is the request struct for api OnsGroupConsumerUpdate
type OnsGroupConsumerUpdateRequest struct {
	*requests.RpcRequest
	GroupId    string           `position:"Query" name:"GroupId"`
	ReadEnable requests.Boolean `position:"Query" name:"ReadEnable"`
	InstanceId string           `position:"Query" name:"InstanceId"`
}

// OnsGroupConsumerUpdateResponse is the response struct for api OnsGroupConsumerUpdate
type OnsGroupConsumerUpdateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HelpUrl   string `json:"HelpUrl" xml:"HelpUrl"`
}

// CreateOnsGroupConsumerUpdateRequest creates a request to invoke OnsGroupConsumerUpdate API
func CreateOnsGroupConsumerUpdateRequest() (request *OnsGroupConsumerUpdateRequest) {
	request = &OnsGroupConsumerUpdateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsGroupConsumerUpdate", "ons", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOnsGroupConsumerUpdateResponse creates a response to parse from OnsGroupConsumerUpdate response
func CreateOnsGroupConsumerUpdateResponse() (response *OnsGroupConsumerUpdateResponse) {
	response = &OnsGroupConsumerUpdateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
