package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAccountPassword invokes the openanalytics_open.UpdateAccountPassword API synchronously
func (client *Client) UpdateAccountPassword(request *UpdateAccountPasswordRequest) (response *UpdateAccountPasswordResponse, err error) {
	response = CreateUpdateAccountPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAccountPasswordWithChan invokes the openanalytics_open.UpdateAccountPassword API asynchronously
func (client *Client) UpdateAccountPasswordWithChan(request *UpdateAccountPasswordRequest) (<-chan *UpdateAccountPasswordResponse, <-chan error) {
	responseChan := make(chan *UpdateAccountPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAccountPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAccountPasswordWithCallback invokes the openanalytics_open.UpdateAccountPassword API asynchronously
func (client *Client) UpdateAccountPasswordWithCallback(request *UpdateAccountPasswordRequest, callback func(response *UpdateAccountPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAccountPasswordResponse
		var err error
		defer close(result)
		response, err = client.UpdateAccountPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAccountPasswordRequest is the request struct for api UpdateAccountPassword
type UpdateAccountPasswordRequest struct {
	*requests.RpcRequest
	IsShort           requests.Boolean `position:"Body" name:"IsShort"`
	Password          string           `position:"Body" name:"Password"`
	AccountName       string           `position:"Body" name:"AccountName"`
	EnableKMS         requests.Boolean `position:"Body" name:"EnableKMS"`
	UseRandomPassword requests.Boolean `position:"Body" name:"UseRandomPassword"`
}

// UpdateAccountPasswordResponse is the response struct for api UpdateAccountPassword
type UpdateAccountPasswordResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	RegionId  string  `json:"RegionId" xml:"RegionId"`
	Account   Account `json:"Account" xml:"Account"`
}

// CreateUpdateAccountPasswordRequest creates a request to invoke UpdateAccountPassword API
func CreateUpdateAccountPasswordRequest() (request *UpdateAccountPasswordRequest) {
	request = &UpdateAccountPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2018-06-19", "UpdateAccountPassword", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAccountPasswordResponse creates a response to parse from UpdateAccountPassword response
func CreateUpdateAccountPasswordResponse() (response *UpdateAccountPasswordResponse) {
	response = &UpdateAccountPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
