package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAgentBySkillGroupId invokes the scsp.ListAgentBySkillGroupId API synchronously
func (client *Client) ListAgentBySkillGroupId(request *ListAgentBySkillGroupIdRequest) (response *ListAgentBySkillGroupIdResponse, err error) {
	response = CreateListAgentBySkillGroupIdResponse()
	err = client.DoAction(request, response)
	return
}

// ListAgentBySkillGroupIdWithChan invokes the scsp.ListAgentBySkillGroupId API asynchronously
func (client *Client) ListAgentBySkillGroupIdWithChan(request *ListAgentBySkillGroupIdRequest) (<-chan *ListAgentBySkillGroupIdResponse, <-chan error) {
	responseChan := make(chan *ListAgentBySkillGroupIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAgentBySkillGroupId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAgentBySkillGroupIdWithCallback invokes the scsp.ListAgentBySkillGroupId API asynchronously
func (client *Client) ListAgentBySkillGroupIdWithCallback(request *ListAgentBySkillGroupIdRequest, callback func(response *ListAgentBySkillGroupIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAgentBySkillGroupIdResponse
		var err error
		defer close(result)
		response, err = client.ListAgentBySkillGroupId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAgentBySkillGroupIdRequest is the request struct for api ListAgentBySkillGroupId
type ListAgentBySkillGroupIdRequest struct {
	*requests.RpcRequest
	ClientToken  string           `position:"Query"`
	InstanceId   string           `position:"Query"`
	SkillGroupId requests.Integer `position:"Query"`
}

// ListAgentBySkillGroupIdResponse is the response struct for api ListAgentBySkillGroupId
type ListAgentBySkillGroupIdResponse struct {
	*responses.BaseResponse
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Code      string   `json:"Code" xml:"Code"`
	Success   bool     `json:"Success" xml:"Success"`
	Data      []Agents `json:"Data" xml:"Data"`
}

// CreateListAgentBySkillGroupIdRequest creates a request to invoke ListAgentBySkillGroupId API
func CreateListAgentBySkillGroupIdRequest() (request *ListAgentBySkillGroupIdRequest) {
	request = &ListAgentBySkillGroupIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "ListAgentBySkillGroupId", "", "")
	request.Method = requests.GET
	return
}

// CreateListAgentBySkillGroupIdResponse creates a response to parse from ListAgentBySkillGroupId response
func CreateListAgentBySkillGroupIdResponse() (response *ListAgentBySkillGroupIdResponse) {
	response = &ListAgentBySkillGroupIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
