// This file is generated by "./lib/proto/generate"

package proto

import (
	"github.com/ysmood/gson"
)

/*

Network

Network domain allows tracking network activities of the page. It exposes information about http,
file, data and other requests and responses, their headers, bodies, timing, etc.

*/

// NetworkResourceType Resource type as it was perceived by the rendering engine.
type NetworkResourceType string

const (
	// NetworkResourceTypeDocument enum const.
	NetworkResourceTypeDocument NetworkResourceType = "Document"

	// NetworkResourceTypeStylesheet enum const.
	NetworkResourceTypeStylesheet NetworkResourceType = "Stylesheet"

	// NetworkResourceTypeImage enum const.
	NetworkResourceTypeImage NetworkResourceType = "Image"

	// NetworkResourceTypeMedia enum const.
	NetworkResourceTypeMedia NetworkResourceType = "Media"

	// NetworkResourceTypeFont enum const.
	NetworkResourceTypeFont NetworkResourceType = "Font"

	// NetworkResourceTypeScript enum const.
	NetworkResourceTypeScript NetworkResourceType = "Script"

	// NetworkResourceTypeTextTrack enum const.
	NetworkResourceTypeTextTrack NetworkResourceType = "TextTrack"

	// NetworkResourceTypeXHR enum const.
	NetworkResourceTypeXHR NetworkResourceType = "XHR"

	// NetworkResourceTypeFetch enum const.
	NetworkResourceTypeFetch NetworkResourceType = "Fetch"

	// NetworkResourceTypePrefetch enum const.
	NetworkResourceTypePrefetch NetworkResourceType = "Prefetch"

	// NetworkResourceTypeEventSource enum const.
	NetworkResourceTypeEventSource NetworkResourceType = "EventSource"

	// NetworkResourceTypeWebSocket enum const.
	NetworkResourceTypeWebSocket NetworkResourceType = "WebSocket"

	// NetworkResourceTypeManifest enum const.
	NetworkResourceTypeManifest NetworkResourceType = "Manifest"

	// NetworkResourceTypeSignedExchange enum const.
	NetworkResourceTypeSignedExchange NetworkResourceType = "SignedExchange"

	// NetworkResourceTypePing enum const.
	NetworkResourceTypePing NetworkResourceType = "Ping"

	// NetworkResourceTypeCSPViolationReport enum const.
	NetworkResourceTypeCSPViolationReport NetworkResourceType = "CSPViolationReport"

	// NetworkResourceTypePreflight enum const.
	NetworkResourceTypePreflight NetworkResourceType = "Preflight"

	// NetworkResourceTypeOther enum const.
	NetworkResourceTypeOther NetworkResourceType = "Other"
)

// NetworkLoaderID Unique loader identifier.
type NetworkLoaderID string

// NetworkRequestID Unique request identifier.
type NetworkRequestID string

// NetworkInterceptionID Unique intercepted request identifier.
type NetworkInterceptionID string

// NetworkErrorReason Network level fetch failure reason.
type NetworkErrorReason string

const (
	// NetworkErrorReasonFailed enum const.
	NetworkErrorReasonFailed NetworkErrorReason = "Failed"

	// NetworkErrorReasonAborted enum const.
	NetworkErrorReasonAborted NetworkErrorReason = "Aborted"

	// NetworkErrorReasonTimedOut enum const.
	NetworkErrorReasonTimedOut NetworkErrorReason = "TimedOut"

	// NetworkErrorReasonAccessDenied enum const.
	NetworkErrorReasonAccessDenied NetworkErrorReason = "AccessDenied"

	// NetworkErrorReasonConnectionClosed enum const.
	NetworkErrorReasonConnectionClosed NetworkErrorReason = "ConnectionClosed"

	// NetworkErrorReasonConnectionReset enum const.
	NetworkErrorReasonConnectionReset NetworkErrorReason = "ConnectionReset"

	// NetworkErrorReasonConnectionRefused enum const.
	NetworkErrorReasonConnectionRefused NetworkErrorReason = "ConnectionRefused"

	// NetworkErrorReasonConnectionAborted enum const.
	NetworkErrorReasonConnectionAborted NetworkErrorReason = "ConnectionAborted"

	// NetworkErrorReasonConnectionFailed enum const.
	NetworkErrorReasonConnectionFailed NetworkErrorReason = "ConnectionFailed"

	// NetworkErrorReasonNameNotResolved enum const.
	NetworkErrorReasonNameNotResolved NetworkErrorReason = "NameNotResolved"

	// NetworkErrorReasonInternetDisconnected enum const.
	NetworkErrorReasonInternetDisconnected NetworkErrorReason = "InternetDisconnected"

	// NetworkErrorReasonAddressUnreachable enum const.
	NetworkErrorReasonAddressUnreachable NetworkErrorReason = "AddressUnreachable"

	// NetworkErrorReasonBlockedByClient enum const.
	NetworkErrorReasonBlockedByClient NetworkErrorReason = "BlockedByClient"

	// NetworkErrorReasonBlockedByResponse enum const.
	NetworkErrorReasonBlockedByResponse NetworkErrorReason = "BlockedByResponse"
)

// NetworkHeaders Request / response headers as keys / values of JSON object.
type NetworkHeaders map[string]gson.JSON

// NetworkConnectionType The underlying connection technology that the browser is supposedly using.
type NetworkConnectionType string

const (
	// NetworkConnectionTypeNone enum const.
	NetworkConnectionTypeNone NetworkConnectionType = "none"

	// NetworkConnectionTypeCellular2g enum const.
	NetworkConnectionTypeCellular2g NetworkConnectionType = "cellular2g"

	// NetworkConnectionTypeCellular3g enum const.
	NetworkConnectionTypeCellular3g NetworkConnectionType = "cellular3g"

	// NetworkConnectionTypeCellular4g enum const.
	NetworkConnectionTypeCellular4g NetworkConnectionType = "cellular4g"

	// NetworkConnectionTypeBluetooth enum const.
	NetworkConnectionTypeBluetooth NetworkConnectionType = "bluetooth"

	// NetworkConnectionTypeEthernet enum const.
	NetworkConnectionTypeEthernet NetworkConnectionType = "ethernet"

	// NetworkConnectionTypeWifi enum const.
	NetworkConnectionTypeWifi NetworkConnectionType = "wifi"

	// NetworkConnectionTypeWimax enum const.
	NetworkConnectionTypeWimax NetworkConnectionType = "wimax"

	// NetworkConnectionTypeOther enum const.
	NetworkConnectionTypeOther NetworkConnectionType = "other"
)

// NetworkCookieSameSite Represents the cookie's 'SameSite' status:
// https://tools.ietf.org/html/draft-west-first-party-cookies
type NetworkCookieSameSite string

const (
	// NetworkCookieSameSiteStrict enum const.
	NetworkCookieSameSiteStrict NetworkCookieSameSite = "Strict"

	// NetworkCookieSameSiteLax enum const.
	NetworkCookieSameSiteLax NetworkCookieSameSite = "Lax"

	// NetworkCookieSameSiteNone enum const.
	NetworkCookieSameSiteNone NetworkCookieSameSite = "None"
)

// NetworkCookiePriority (experimental) Represents the cookie's 'Priority' status:
// https://tools.ietf.org/html/draft-west-cookie-priority-00
type NetworkCookiePriority string

const (
	// NetworkCookiePriorityLow enum const.
	NetworkCookiePriorityLow NetworkCookiePriority = "Low"

	// NetworkCookiePriorityMedium enum const.
	NetworkCookiePriorityMedium NetworkCookiePriority = "Medium"

	// NetworkCookiePriorityHigh enum const.
	NetworkCookiePriorityHigh NetworkCookiePriority = "High"
)

// NetworkCookieSourceScheme (experimental) Represents the source scheme of the origin that originally set the cookie.
// A value of "Unset" allows protocol clients to emulate legacy cookie scope for the scheme.
// This is a temporary ability and it will be removed in the future.
type NetworkCookieSourceScheme string

const (
	// NetworkCookieSourceSchemeUnset enum const.
	NetworkCookieSourceSchemeUnset NetworkCookieSourceScheme = "Unset"

	// NetworkCookieSourceSchemeNonSecure enum const.
	NetworkCookieSourceSchemeNonSecure NetworkCookieSourceScheme = "NonSecure"

	// NetworkCookieSourceSchemeSecure enum const.
	NetworkCookieSourceSchemeSecure NetworkCookieSourceScheme = "Secure"
)

// NetworkResourceTiming Timing information for the request.
type NetworkResourceTiming struct {
	// RequestTime Timing's requestTime is a baseline in seconds, while the other numbers are ticks in
	// milliseconds relatively to this requestTime.
	RequestTime float64 `json:"requestTime"`

	// ProxyStart Started resolving proxy.
	ProxyStart float64 `json:"proxyStart"`

	// ProxyEnd Finished resolving proxy.
	ProxyEnd float64 `json:"proxyEnd"`

	// DNSStart Started DNS address resolve.
	DNSStart float64 `json:"dnsStart"`

	// DNSEnd Finished DNS address resolve.
	DNSEnd float64 `json:"dnsEnd"`

	// ConnectStart Started connecting to the remote host.
	ConnectStart float64 `json:"connectStart"`

	// ConnectEnd Connected to the remote host.
	ConnectEnd float64 `json:"connectEnd"`

	// SslStart Started SSL handshake.
	SslStart float64 `json:"sslStart"`

	// SslEnd Finished SSL handshake.
	SslEnd float64 `json:"sslEnd"`

	// WorkerStart (experimental) Started running ServiceWorker.
	WorkerStart float64 `json:"workerStart"`

	// WorkerReady (experimental) Finished Starting ServiceWorker.
	WorkerReady float64 `json:"workerReady"`

	// WorkerFetchStart (experimental) Started fetch event.
	WorkerFetchStart float64 `json:"workerFetchStart"`

	// WorkerRespondWithSettled (experimental) Settled fetch event respondWith promise.
	WorkerRespondWithSettled float64 `json:"workerRespondWithSettled"`

	// SendStart Started sending request.
	SendStart float64 `json:"sendStart"`

	// SendEnd Finished sending request.
	SendEnd float64 `json:"sendEnd"`

	// PushStart (experimental) Time the server started pushing request.
	PushStart float64 `json:"pushStart"`

	// PushEnd (experimental) Time the server finished pushing request.
	PushEnd float64 `json:"pushEnd"`

	// ReceiveHeadersStart (experimental) Started receiving response headers.
	ReceiveHeadersStart float64 `json:"receiveHeadersStart"`

	// ReceiveHeadersEnd Finished receiving response headers.
	ReceiveHeadersEnd float64 `json:"receiveHeadersEnd"`
}

// NetworkResourcePriority Loading priority of a resource request.
type NetworkResourcePriority string

const (
	// NetworkResourcePriorityVeryLow enum const.
	NetworkResourcePriorityVeryLow NetworkResourcePriority = "VeryLow"

	// NetworkResourcePriorityLow enum const.
	NetworkResourcePriorityLow NetworkResourcePriority = "Low"

	// NetworkResourcePriorityMedium enum const.
	NetworkResourcePriorityMedium NetworkResourcePriority = "Medium"

	// NetworkResourcePriorityHigh enum const.
	NetworkResourcePriorityHigh NetworkResourcePriority = "High"

	// NetworkResourcePriorityVeryHigh enum const.
	NetworkResourcePriorityVeryHigh NetworkResourcePriority = "VeryHigh"
)

// NetworkPostDataEntry Post data entry for HTTP request.
type NetworkPostDataEntry struct {
	// Bytes (optional) ...
	Bytes []byte `json:"bytes,omitempty"`
}

// NetworkRequestReferrerPolicy enum.
type NetworkRequestReferrerPolicy string

const (
	// NetworkRequestReferrerPolicyUnsafeURL enum const.
	NetworkRequestReferrerPolicyUnsafeURL NetworkRequestReferrerPolicy = "unsafe-url"

	// NetworkRequestReferrerPolicyNoReferrerWhenDowngrade enum const.
	NetworkRequestReferrerPolicyNoReferrerWhenDowngrade NetworkRequestReferrerPolicy = "no-referrer-when-downgrade"

	// NetworkRequestReferrerPolicyNoReferrer enum const.
	NetworkRequestReferrerPolicyNoReferrer NetworkRequestReferrerPolicy = "no-referrer"

	// NetworkRequestReferrerPolicyOrigin enum const.
	NetworkRequestReferrerPolicyOrigin NetworkRequestReferrerPolicy = "origin"

	// NetworkRequestReferrerPolicyOriginWhenCrossOrigin enum const.
	NetworkRequestReferrerPolicyOriginWhenCrossOrigin NetworkRequestReferrerPolicy = "origin-when-cross-origin"

	// NetworkRequestReferrerPolicySameOrigin enum const.
	NetworkRequestReferrerPolicySameOrigin NetworkRequestReferrerPolicy = "same-origin"

	// NetworkRequestReferrerPolicyStrictOrigin enum const.
	NetworkRequestReferrerPolicyStrictOrigin NetworkRequestReferrerPolicy = "strict-origin"

	// NetworkRequestReferrerPolicyStrictOriginWhenCrossOrigin enum const.
	NetworkRequestReferrerPolicyStrictOriginWhenCrossOrigin NetworkRequestReferrerPolicy = "strict-origin-when-cross-origin"
)

// NetworkRequest HTTP request data.
type NetworkRequest struct {
	// URL Request URL (without fragment).
	URL string `json:"url"`

	// URLFragment (optional) Fragment of the requested URL starting with hash, if present.
	URLFragment string `json:"urlFragment,omitempty"`

	// Method HTTP request method.
	Method string `json:"method"`

	// Headers HTTP request headers.
	Headers NetworkHeaders `json:"headers"`

	// PostData (deprecated) (optional) HTTP POST request data.
	// Use postDataEntries instead.
	PostData string `json:"postData,omitempty"`

	// HasPostData (optional) True when the request has POST data. Note that postData might still be omitted when this flag is true when the data is too long.
	HasPostData bool `json:"hasPostData,omitempty"`

	// PostDataEntries (experimental) (optional) Request body elements (post data broken into individual entries).
	PostDataEntries []*NetworkPostDataEntry `json:"postDataEntries,omitempty"`

	// MixedContentType (optional) The mixed content type of the request.
	MixedContentType SecurityMixedContentType `json:"mixedContentType,omitempty"`

	// InitialPriority Priority of the resource request at the time request is sent.
	InitialPriority NetworkResourcePriority `json:"initialPriority"`

	// ReferrerPolicy The referrer policy of the request, as defined in https://www.w3.org/TR/referrer-policy/
	ReferrerPolicy NetworkRequestReferrerPolicy `json:"referrerPolicy"`

	// IsLinkPreload (optional) Whether is loaded via link preload.
	IsLinkPreload bool `json:"isLinkPreload,omitempty"`

	// TrustTokenParams (experimental) (optional) Set for requests when the TrustToken API is used. Contains the parameters
	// passed by the developer (e.g. via "fetch") as understood by the backend.
	TrustTokenParams *NetworkTrustTokenParams `json:"trustTokenParams,omitempty"`

	// IsSameSite (experimental) (optional) True if this resource request is considered to be the 'same site' as the
	// request corresponding to the main frame.
	IsSameSite bool `json:"isSameSite,omitempty"`
}

// NetworkSignedCertificateTimestamp Details of a signed certificate timestamp (SCT).
type NetworkSignedCertificateTimestamp struct {
	// Status Validation status.
	Status string `json:"status"`

	// Origin.
	Origin string `json:"origin"`

	// LogDescription Log name / description.
	LogDescription string `json:"logDescription"`

	// LogID Log ID.
	LogID string `json:"logId"`

	// Timestamp Issuance date. Unlike TimeSinceEpoch, this contains the number of
	// milliseconds since January 1, 1970, UTC, not the number of seconds.
	Timestamp float64 `json:"timestamp"`

	// HashAlgorithm Hash algorithm.
	HashAlgorithm string `json:"hashAlgorithm"`

	// SignatureAlgorithm Signature algorithm.
	SignatureAlgorithm string `json:"signatureAlgorithm"`

	// SignatureData Signature data.
	SignatureData string `json:"signatureData"`
}

// NetworkSecurityDetails Security details about a request.
type NetworkSecurityDetails struct {
	// Protocol name (e.g. "TLS 1.2" or "QUIC").
	Protocol string `json:"protocol"`

	// KeyExchange Key Exchange used by the connection, or the empty string if not applicable.
	KeyExchange string `json:"keyExchange"`

	// KeyExchangeGroup (optional) (EC)DH group used by the connection, if applicable.
	KeyExchangeGroup string `json:"keyExchangeGroup,omitempty"`

	// Cipher name.
	Cipher string `json:"cipher"`

	// Mac (optional) TLS MAC. Note that AEAD ciphers do not have separate MACs.
	Mac string `json:"mac,omitempty"`

	// CertificateID Certificate ID value.
	CertificateID SecurityCertificateID `json:"certificateId"`

	// SubjectName Certificate subject name.
	SubjectName string `json:"subjectName"`

	// SanList Subject Alternative Name (SAN) DNS names and IP addresses.
	SanList []string `json:"sanList"`

	// Issuer Name of the issuing CA.
	Issuer string `json:"issuer"`

	// ValidFrom Certificate valid from date.
	ValidFrom TimeSinceEpoch `json:"validFrom"`

	// ValidTo Certificate valid to (expiration) date
	ValidTo TimeSinceEpoch `json:"validTo"`

	// SignedCertificateTimestampList List of signed certificate timestamps (SCTs).
	SignedCertificateTimestampList []*NetworkSignedCertificateTimestamp `json:"signedCertificateTimestampList"`

	// CertificateTransparencyCompliance Whether the request complied with Certificate Transparency policy
	CertificateTransparencyCompliance NetworkCertificateTransparencyCompliance `json:"certificateTransparencyCompliance"`

	// ServerSignatureAlgorithm (optional) The signature algorithm used by the server in the TLS server signature,
	// represented as a TLS SignatureScheme code point. Omitted if not
	// applicable or not known.
	ServerSignatureAlgorithm *int `json:"serverSignatureAlgorithm,omitempty"`

	// EncryptedClientHello Whether the connection used Encrypted ClientHello
	EncryptedClientHello bool `json:"encryptedClientHello"`
}

// NetworkCertificateTransparencyCompliance Whether the request complied with Certificate Transparency policy.
type NetworkCertificateTransparencyCompliance string

const (
	// NetworkCertificateTransparencyComplianceUnknown enum const.
	NetworkCertificateTransparencyComplianceUnknown NetworkCertificateTransparencyCompliance = "unknown"

	// NetworkCertificateTransparencyComplianceNotCompliant enum const.
	NetworkCertificateTransparencyComplianceNotCompliant NetworkCertificateTransparencyCompliance = "not-compliant"

	// NetworkCertificateTransparencyComplianceCompliant enum const.
	NetworkCertificateTransparencyComplianceCompliant NetworkCertificateTransparencyCompliance = "compliant"
)

// NetworkBlockedReason The reason why request was blocked.
type NetworkBlockedReason string

const (
	// NetworkBlockedReasonOther enum const.
	NetworkBlockedReasonOther NetworkBlockedReason = "other"

	// NetworkBlockedReasonCsp enum const.
	NetworkBlockedReasonCsp NetworkBlockedReason = "csp"

	// NetworkBlockedReasonMixedContent enum const.
	NetworkBlockedReasonMixedContent NetworkBlockedReason = "mixed-content"

	// NetworkBlockedReasonOrigin enum const.
	NetworkBlockedReasonOrigin NetworkBlockedReason = "origin"

	// NetworkBlockedReasonInspector enum const.
	NetworkBlockedReasonInspector NetworkBlockedReason = "inspector"

	// NetworkBlockedReasonSubresourceFilter enum const.
	NetworkBlockedReasonSubresourceFilter NetworkBlockedReason = "subresource-filter"

	// NetworkBlockedReasonContentType enum const.
	NetworkBlockedReasonContentType NetworkBlockedReason = "content-type"

	// NetworkBlockedReasonCoepFrameResourceNeedsCoepHeader enum const.
	NetworkBlockedReasonCoepFrameResourceNeedsCoepHeader NetworkBlockedReason = "coep-frame-resource-needs-coep-header"

	// NetworkBlockedReasonCoopSandboxedIframeCannotNavigateToCoopPage enum const.
	NetworkBlockedReasonCoopSandboxedIframeCannotNavigateToCoopPage NetworkBlockedReason = "coop-sandboxed-iframe-cannot-navigate-to-coop-page"

	// NetworkBlockedReasonCorpNotSameOrigin enum const.
	NetworkBlockedReasonCorpNotSameOrigin NetworkBlockedReason = "corp-not-same-origin"

	// NetworkBlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep enum const.
	NetworkBlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep NetworkBlockedReason = "corp-not-same-origin-after-defaulted-to-same-origin-by-coep"

	// NetworkBlockedReasonCorpNotSameSite enum const.
	NetworkBlockedReasonCorpNotSameSite NetworkBlockedReason = "corp-not-same-site"
)

// NetworkCorsError The reason why request was blocked.
type NetworkCorsError string

const (
	// NetworkCorsErrorDisallowedByMode enum const.
	NetworkCorsErrorDisallowedByMode NetworkCorsError = "DisallowedByMode"

	// NetworkCorsErrorInvalidResponse enum const.
	NetworkCorsErrorInvalidResponse NetworkCorsError = "InvalidResponse"

	// NetworkCorsErrorWildcardOriginNotAllowed enum const.
	NetworkCorsErrorWildcardOriginNotAllowed NetworkCorsError = "WildcardOriginNotAllowed"

	// NetworkCorsErrorMissingAllowOriginHeader enum const.
	NetworkCorsErrorMissingAllowOriginHeader NetworkCorsError = "MissingAllowOriginHeader"

	// NetworkCorsErrorMultipleAllowOriginValues enum const.
	NetworkCorsErrorMultipleAllowOriginValues NetworkCorsError = "MultipleAllowOriginValues"

	// NetworkCorsErrorInvalidAllowOriginValue enum const.
	NetworkCorsErrorInvalidAllowOriginValue NetworkCorsError = "InvalidAllowOriginValue"

	// NetworkCorsErrorAllowOriginMismatch enum const.
	NetworkCorsErrorAllowOriginMismatch NetworkCorsError = "AllowOriginMismatch"

	// NetworkCorsErrorInvalidAllowCredentials enum const.
	NetworkCorsErrorInvalidAllowCredentials NetworkCorsError = "InvalidAllowCredentials"

	// NetworkCorsErrorCorsDisabledScheme enum const.
	NetworkCorsErrorCorsDisabledScheme NetworkCorsError = "CorsDisabledScheme"

	// NetworkCorsErrorPreflightInvalidStatus enum const.
	NetworkCorsErrorPreflightInvalidStatus NetworkCorsError = "PreflightInvalidStatus"

	// NetworkCorsErrorPreflightDisallowedRedirect enum const.
	NetworkCorsErrorPreflightDisallowedRedirect NetworkCorsError = "PreflightDisallowedRedirect"

	// NetworkCorsErrorPreflightWildcardOriginNotAllowed enum const.
	NetworkCorsErrorPreflightWildcardOriginNotAllowed NetworkCorsError = "PreflightWildcardOriginNotAllowed"

	// NetworkCorsErrorPreflightMissingAllowOriginHeader enum const.
	NetworkCorsErrorPreflightMissingAllowOriginHeader NetworkCorsError = "PreflightMissingAllowOriginHeader"

	// NetworkCorsErrorPreflightMultipleAllowOriginValues enum const.
	NetworkCorsErrorPreflightMultipleAllowOriginValues NetworkCorsError = "PreflightMultipleAllowOriginValues"

	// NetworkCorsErrorPreflightInvalidAllowOriginValue enum const.
	NetworkCorsErrorPreflightInvalidAllowOriginValue NetworkCorsError = "PreflightInvalidAllowOriginValue"

	// NetworkCorsErrorPreflightAllowOriginMismatch enum const.
	NetworkCorsErrorPreflightAllowOriginMismatch NetworkCorsError = "PreflightAllowOriginMismatch"

	// NetworkCorsErrorPreflightInvalidAllowCredentials enum const.
	NetworkCorsErrorPreflightInvalidAllowCredentials NetworkCorsError = "PreflightInvalidAllowCredentials"

	// NetworkCorsErrorPreflightMissingAllowExternal enum const.
	NetworkCorsErrorPreflightMissingAllowExternal NetworkCorsError = "PreflightMissingAllowExternal"

	// NetworkCorsErrorPreflightInvalidAllowExternal enum const.
	NetworkCorsErrorPreflightInvalidAllowExternal NetworkCorsError = "PreflightInvalidAllowExternal"

	// NetworkCorsErrorPreflightMissingAllowPrivateNetwork enum const.
	NetworkCorsErrorPreflightMissingAllowPrivateNetwork NetworkCorsError = "PreflightMissingAllowPrivateNetwork"

	// NetworkCorsErrorPreflightInvalidAllowPrivateNetwork enum const.
	NetworkCorsErrorPreflightInvalidAllowPrivateNetwork NetworkCorsError = "PreflightInvalidAllowPrivateNetwork"

	// NetworkCorsErrorInvalidAllowMethodsPreflightResponse enum const.
	NetworkCorsErrorInvalidAllowMethodsPreflightResponse NetworkCorsError = "InvalidAllowMethodsPreflightResponse"

	// NetworkCorsErrorInvalidAllowHeadersPreflightResponse enum const.
	NetworkCorsErrorInvalidAllowHeadersPreflightResponse NetworkCorsError = "InvalidAllowHeadersPreflightResponse"

	// NetworkCorsErrorMethodDisallowedByPreflightResponse enum const.
	NetworkCorsErrorMethodDisallowedByPreflightResponse NetworkCorsError = "MethodDisallowedByPreflightResponse"

	// NetworkCorsErrorHeaderDisallowedByPreflightResponse enum const.
	NetworkCorsErrorHeaderDisallowedByPreflightResponse NetworkCorsError = "HeaderDisallowedByPreflightResponse"

	// NetworkCorsErrorRedirectContainsCredentials enum const.
	NetworkCorsErrorRedirectContainsCredentials NetworkCorsError = "RedirectContainsCredentials"

	// NetworkCorsErrorInsecurePrivateNetwork enum const.
	NetworkCorsErrorInsecurePrivateNetwork NetworkCorsError = "InsecurePrivateNetwork"

	// NetworkCorsErrorInvalidPrivateNetworkAccess enum const.
	NetworkCorsErrorInvalidPrivateNetworkAccess NetworkCorsError = "InvalidPrivateNetworkAccess"

	// NetworkCorsErrorUnexpectedPrivateNetworkAccess enum const.
	NetworkCorsErrorUnexpectedPrivateNetworkAccess NetworkCorsError = "UnexpectedPrivateNetworkAccess"

	// NetworkCorsErrorNoCorsRedirectModeNotFollow enum const.
	NetworkCorsErrorNoCorsRedirectModeNotFollow NetworkCorsError = "NoCorsRedirectModeNotFollow"

	// NetworkCorsErrorPreflightMissingPrivateNetworkAccessID enum const.
	NetworkCorsErrorPreflightMissingPrivateNetworkAccessID NetworkCorsError = "PreflightMissingPrivateNetworkAccessId"

	// NetworkCorsErrorPreflightMissingPrivateNetworkAccessName enum const.
	NetworkCorsErrorPreflightMissingPrivateNetworkAccessName NetworkCorsError = "PreflightMissingPrivateNetworkAccessName"

	// NetworkCorsErrorPrivateNetworkAccessPermissionUnavailable enum const.
	NetworkCorsErrorPrivateNetworkAccessPermissionUnavailable NetworkCorsError = "PrivateNetworkAccessPermissionUnavailable"

	// NetworkCorsErrorPrivateNetworkAccessPermissionDenied enum const.
	NetworkCorsErrorPrivateNetworkAccessPermissionDenied NetworkCorsError = "PrivateNetworkAccessPermissionDenied"
)

// NetworkCorsErrorStatus ...
type NetworkCorsErrorStatus struct {
	// CorsError ...
	CorsError NetworkCorsError `json:"corsError"`

	// FailedParameter ...
	FailedParameter string `json:"failedParameter"`
}

// NetworkServiceWorkerResponseSource Source of serviceworker response.
type NetworkServiceWorkerResponseSource string

const (
	// NetworkServiceWorkerResponseSourceCacheStorage enum const.
	NetworkServiceWorkerResponseSourceCacheStorage NetworkServiceWorkerResponseSource = "cache-storage"

	// NetworkServiceWorkerResponseSourceHTTPCache enum const.
	NetworkServiceWorkerResponseSourceHTTPCache NetworkServiceWorkerResponseSource = "http-cache"

	// NetworkServiceWorkerResponseSourceFallbackCode enum const.
	NetworkServiceWorkerResponseSourceFallbackCode NetworkServiceWorkerResponseSource = "fallback-code"

	// NetworkServiceWorkerResponseSourceNetwork enum const.
	NetworkServiceWorkerResponseSourceNetwork NetworkServiceWorkerResponseSource = "network"
)

// NetworkTrustTokenParamsRefreshPolicy enum.
type NetworkTrustTokenParamsRefreshPolicy string

const (
	// NetworkTrustTokenParamsRefreshPolicyUseCached enum const.
	NetworkTrustTokenParamsRefreshPolicyUseCached NetworkTrustTokenParamsRefreshPolicy = "UseCached"

	// NetworkTrustTokenParamsRefreshPolicyRefresh enum const.
	NetworkTrustTokenParamsRefreshPolicyRefresh NetworkTrustTokenParamsRefreshPolicy = "Refresh"
)

// NetworkTrustTokenParams (experimental) Determines what type of Trust Token operation is executed and
// depending on the type, some additional parameters. The values
// are specified in third_party/blink/renderer/core/fetch/trust_token.idl.
type NetworkTrustTokenParams struct {
	// Operation ...
	Operation NetworkTrustTokenOperationType `json:"operation"`

	// RefreshPolicy Only set for "token-redemption" operation and determine whether
	// to request a fresh SRR or use a still valid cached SRR.
	RefreshPolicy NetworkTrustTokenParamsRefreshPolicy `json:"refreshPolicy"`

	// Issuers (optional) Origins of issuers from whom to request tokens or redemption
	// records.
	Issuers []string `json:"issuers,omitempty"`
}

// NetworkTrustTokenOperationType (experimental) ...
type NetworkTrustTokenOperationType string

const (
	// NetworkTrustTokenOperationTypeIssuance enum const.
	NetworkTrustTokenOperationTypeIssuance NetworkTrustTokenOperationType = "Issuance"

	// NetworkTrustTokenOperationTypeRedemption enum const.
	NetworkTrustTokenOperationTypeRedemption NetworkTrustTokenOperationType = "Redemption"

	// NetworkTrustTokenOperationTypeSigning enum const.
	NetworkTrustTokenOperationTypeSigning NetworkTrustTokenOperationType = "Signing"
)

// NetworkAlternateProtocolUsage (experimental) The reason why Chrome uses a specific transport protocol for HTTP semantics.
type NetworkAlternateProtocolUsage string

const (
	// NetworkAlternateProtocolUsageAlternativeJobWonWithoutRace enum const.
	NetworkAlternateProtocolUsageAlternativeJobWonWithoutRace NetworkAlternateProtocolUsage = "alternativeJobWonWithoutRace"

	// NetworkAlternateProtocolUsageAlternativeJobWonRace enum const.
	NetworkAlternateProtocolUsageAlternativeJobWonRace NetworkAlternateProtocolUsage = "alternativeJobWonRace"

	// NetworkAlternateProtocolUsageMainJobWonRace enum const.
	NetworkAlternateProtocolUsageMainJobWonRace NetworkAlternateProtocolUsage = "mainJobWonRace"

	// NetworkAlternateProtocolUsageMappingMissing enum const.
	NetworkAlternateProtocolUsageMappingMissing NetworkAlternateProtocolUsage = "mappingMissing"

	// NetworkAlternateProtocolUsageBroken enum const.
	NetworkAlternateProtocolUsageBroken NetworkAlternateProtocolUsage = "broken"

	// NetworkAlternateProtocolUsageDNSAlpnH3JobWonWithoutRace enum const.
	NetworkAlternateProtocolUsageDNSAlpnH3JobWonWithoutRace NetworkAlternateProtocolUsage = "dnsAlpnH3JobWonWithoutRace"

	// NetworkAlternateProtocolUsageDNSAlpnH3JobWonRace enum const.
	NetworkAlternateProtocolUsageDNSAlpnH3JobWonRace NetworkAlternateProtocolUsage = "dnsAlpnH3JobWonRace"

	// NetworkAlternateProtocolUsageUnspecifiedReason enum const.
	NetworkAlternateProtocolUsageUnspecifiedReason NetworkAlternateProtocolUsage = "unspecifiedReason"
)

// NetworkServiceWorkerRouterSource Source of service worker router.
type NetworkServiceWorkerRouterSource string

const (
	// NetworkServiceWorkerRouterSourceNetwork enum const.
	NetworkServiceWorkerRouterSourceNetwork NetworkServiceWorkerRouterSource = "network"

	// NetworkServiceWorkerRouterSourceCache enum const.
	NetworkServiceWorkerRouterSourceCache NetworkServiceWorkerRouterSource = "cache"

	// NetworkServiceWorkerRouterSourceFetchEvent enum const.
	NetworkServiceWorkerRouterSourceFetchEvent NetworkServiceWorkerRouterSource = "fetch-event"

	// NetworkServiceWorkerRouterSourceRaceNetworkAndFetchHandler enum const.
	NetworkServiceWorkerRouterSourceRaceNetworkAndFetchHandler NetworkServiceWorkerRouterSource = "race-network-and-fetch-handler"
)

// NetworkServiceWorkerRouterInfo (experimental) ...
type NetworkServiceWorkerRouterInfo struct {
	// RuleIDMatched (optional) ID of the rule matched. If there is a matched rule, this field will
	// be set, otherwiser no value will be set.
	RuleIDMatched *int `json:"ruleIdMatched,omitempty"`

	// MatchedSourceType (optional) The router source of the matched rule. If there is a matched rule, this
	// field will be set, otherwise no value will be set.
	MatchedSourceType NetworkServiceWorkerRouterSource `json:"matchedSourceType,omitempty"`
}

// NetworkResponse HTTP response data.
type NetworkResponse struct {
	// URL Response URL. This URL can be different from CachedResource.url in case of redirect.
	URL string `json:"url"`

	// Status HTTP response status code.
	Status int `json:"status"`

	// StatusText HTTP response status text.
	StatusText string `json:"statusText"`

	// Headers HTTP response headers.
	Headers NetworkHeaders `json:"headers"`

	// HeadersText (deprecated) (optional) HTTP response headers text. This has been replaced by the headers in Network.responseReceivedExtraInfo.
	HeadersText string `json:"headersText,omitempty"`

	// MIMEType Resource mimeType as determined by the browser.
	MIMEType string `json:"mimeType"`

	// Charset Resource charset as determined by the browser (if applicable).
	Charset string `json:"charset"`

	// RequestHeaders (optional) Refined HTTP request headers that were actually transmitted over the network.
	RequestHeaders NetworkHeaders `json:"requestHeaders,omitempty"`

	// RequestHeadersText (deprecated) (optional) HTTP request headers text. This has been replaced by the headers in Network.requestWillBeSentExtraInfo.
	RequestHeadersText string `json:"requestHeadersText,omitempty"`

	// ConnectionReused Specifies whether physical connection was actually reused for this request.
	ConnectionReused bool `json:"connectionReused"`

	// ConnectionID Physical connection id that was actually used for this request.
	ConnectionID float64 `json:"connectionId"`

	// RemoteIPAddress (optional) Remote IP address.
	RemoteIPAddress string `json:"remoteIPAddress,omitempty"`

	// RemotePort (optional) Remote port.
	RemotePort *int `json:"remotePort,omitempty"`

	// FromDiskCache (optional) Specifies that the request was served from the disk cache.
	FromDiskCache bool `json:"fromDiskCache,omitempty"`

	// FromServiceWorker (optional) Specifies that the request was served from the ServiceWorker.
	FromServiceWorker bool `json:"fromServiceWorker,omitempty"`

	// FromPrefetchCache (optional) Specifies that the request was served from the prefetch cache.
	FromPrefetchCache bool `json:"fromPrefetchCache,omitempty"`

	// FromEarlyHints (optional) Specifies that the request was served from the prefetch cache.
	FromEarlyHints bool `json:"fromEarlyHints,omitempty"`

	// ServiceWorkerRouterInfo (experimental) (optional) Information about how ServiceWorker Static Router API was used. If this
	// field is set with `matchedSourceType` field, a matching rule is found.
	// If this field is set without `matchedSource`, no matching rule is found.
	// Otherwise, the API is not used.
	ServiceWorkerRouterInfo *NetworkServiceWorkerRouterInfo `json:"serviceWorkerRouterInfo,omitempty"`

	// EncodedDataLength Total number of bytes received for this request so far.
	EncodedDataLength float64 `json:"encodedDataLength"`

	// Timing (optional) Timing information for the given request.
	Timing *NetworkResourceTiming `json:"timing,omitempty"`

	// ServiceWorkerResponseSource (optional) Response source of response from ServiceWorker.
	ServiceWorkerResponseSource NetworkServiceWorkerResponseSource `json:"serviceWorkerResponseSource,omitempty"`

	// ResponseTime (optional) The time at which the returned response was generated.
	ResponseTime TimeSinceEpoch `json:"responseTime,omitempty"`

	// CacheStorageCacheName (optional) Cache Storage Cache Name.
	CacheStorageCacheName string `json:"cacheStorageCacheName,omitempty"`

	// Protocol (optional) Protocol used to fetch this request.
	Protocol string `json:"protocol,omitempty"`

	// AlternateProtocolUsage (experimental) (optional) The reason why Chrome uses a specific transport protocol for HTTP semantics.
	AlternateProtocolUsage NetworkAlternateProtocolUsage `json:"alternateProtocolUsage,omitempty"`

	// SecurityState Security state of the request resource.
	SecurityState SecuritySecurityState `json:"securityState"`

	// SecurityDetails (optional) Security details for the request.
	SecurityDetails *NetworkSecurityDetails `json:"securityDetails,omitempty"`
}

// NetworkWebSocketRequest WebSocket request data.
type NetworkWebSocketRequest struct {
	// Headers HTTP request headers.
	Headers NetworkHeaders `json:"headers"`
}

// NetworkWebSocketResponse WebSocket response data.
type NetworkWebSocketResponse struct {
	// Status HTTP response status code.
	Status int `json:"status"`

	// StatusText HTTP response status text.
	StatusText string `json:"statusText"`

	// Headers HTTP response headers.
	Headers NetworkHeaders `json:"headers"`

	// HeadersText (optional) HTTP response headers text.
	HeadersText string `json:"headersText,omitempty"`

	// RequestHeaders (optional) HTTP request headers.
	RequestHeaders NetworkHeaders `json:"requestHeaders,omitempty"`

	// RequestHeadersText (optional) HTTP request headers text.
	RequestHeadersText string `json:"requestHeadersText,omitempty"`
}

// NetworkWebSocketFrame WebSocket message data. This represents an entire WebSocket message, not just a fragmented frame as the name suggests.
type NetworkWebSocketFrame struct {
	// Opcode WebSocket message opcode.
	Opcode float64 `json:"opcode"`

	// Mask WebSocket message mask.
	Mask bool `json:"mask"`

	// PayloadData WebSocket message payload data.
	// If the opcode is 1, this is a text message and payloadData is a UTF-8 string.
	// If the opcode isn't 1, then payloadData is a base64 encoded string representing binary data.
	PayloadData string `json:"payloadData"`
}

// NetworkCachedResource Information about the cached resource.
type NetworkCachedResource struct {
	// URL Resource URL. This is the url of the original network request.
	URL string `json:"url"`

	// Type of this resource.
	Type NetworkResourceType `json:"type"`

	// Response (optional) Cached response data.
	Response *NetworkResponse `json:"response,omitempty"`

	// BodySize Cached response body size.
	BodySize float64 `json:"bodySize"`
}

// NetworkInitiatorType enum.
type NetworkInitiatorType string

const (
	// NetworkInitiatorTypeParser enum const.
	NetworkInitiatorTypeParser NetworkInitiatorType = "parser"

	// NetworkInitiatorTypeScript enum const.
	NetworkInitiatorTypeScript NetworkInitiatorType = "script"

	// NetworkInitiatorTypePreload enum const.
	NetworkInitiatorTypePreload NetworkInitiatorType = "preload"

	// NetworkInitiatorTypeSignedExchange enum const.
	NetworkInitiatorTypeSignedExchange NetworkInitiatorType = "SignedExchange"

	// NetworkInitiatorTypePreflight enum const.
	NetworkInitiatorTypePreflight NetworkInitiatorType = "preflight"

	// NetworkInitiatorTypeOther enum const.
	NetworkInitiatorTypeOther NetworkInitiatorType = "other"
)

// NetworkInitiator Information about the request initiator.
type NetworkInitiator struct {
	// Type of this initiator.
	Type NetworkInitiatorType `json:"type"`

	// Stack (optional) Initiator JavaScript stack trace, set for Script only.
	Stack *RuntimeStackTrace `json:"stack,omitempty"`

	// URL (optional) Initiator URL, set for Parser type or for Script type (when script is importing module) or for SignedExchange type.
	URL string `json:"url,omitempty"`

	// LineNumber (optional) Initiator line number, set for Parser type or for Script type (when script is importing
	// module) (0-based).
	LineNumber *float64 `json:"lineNumber,omitempty"`

	// ColumnNumber (optional) Initiator column number, set for Parser type or for Script type (when script is importing
	// module) (0-based).
	ColumnNumber *float64 `json:"columnNumber,omitempty"`

	// RequestID (optional) Set if another request triggered this request (e.g. preflight).
	RequestID NetworkRequestID `json:"requestId,omitempty"`
}

// NetworkCookie Cookie object.
type NetworkCookie struct {
	// Name Cookie name.
	Name string `json:"name"`

	// Value Cookie value.
	Value string `json:"value"`

	// Domain Cookie domain.
	Domain string `json:"domain"`

	// Path Cookie path.
	Path string `json:"path"`

	// Expires Cookie expiration date
	Expires TimeSinceEpoch `json:"expires"`

	// Size Cookie size.
	Size int `json:"size"`

	// HTTPOnly True if cookie is http-only.
	HTTPOnly bool `json:"httpOnly"`

	// Secure True if cookie is secure.
	Secure bool `json:"secure"`

	// Session True in case of session cookie.
	Session bool `json:"session"`

	// SameSite (optional) Cookie SameSite type.
	SameSite NetworkCookieSameSite `json:"sameSite,omitempty"`

	// Priority (experimental) Cookie Priority
	Priority NetworkCookiePriority `json:"priority"`

	// SameParty (deprecated) (experimental) True if cookie is SameParty.
	SameParty bool `json:"sameParty"`

	// SourceScheme (experimental) Cookie source scheme type.
	SourceScheme NetworkCookieSourceScheme `json:"sourceScheme"`

	// SourcePort (experimental) Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port.
	// An unspecified port value allows protocol clients to emulate legacy cookie scope for the port.
	// This is a temporary ability and it will be removed in the future.
	SourcePort int `json:"sourcePort"`

	// PartitionKey (experimental) (optional) Cookie partition key. The site of the top-level URL the browser was visiting at the start
	// of the request to the endpoint that set the cookie.
	PartitionKey string `json:"partitionKey,omitempty"`

	// PartitionKeyOpaque (experimental) (optional) True if cookie partition key is opaque.
	PartitionKeyOpaque bool `json:"partitionKeyOpaque,omitempty"`
}

// NetworkSetCookieBlockedReason (experimental) Types of reasons why a cookie may not be stored from a response.
type NetworkSetCookieBlockedReason string

const (
	// NetworkSetCookieBlockedReasonSecureOnly enum const.
	NetworkSetCookieBlockedReasonSecureOnly NetworkSetCookieBlockedReason = "SecureOnly"

	// NetworkSetCookieBlockedReasonSameSiteStrict enum const.
	NetworkSetCookieBlockedReasonSameSiteStrict NetworkSetCookieBlockedReason = "SameSiteStrict"

	// NetworkSetCookieBlockedReasonSameSiteLax enum const.
	NetworkSetCookieBlockedReasonSameSiteLax NetworkSetCookieBlockedReason = "SameSiteLax"

	// NetworkSetCookieBlockedReasonSameSiteUnspecifiedTreatedAsLax enum const.
	NetworkSetCookieBlockedReasonSameSiteUnspecifiedTreatedAsLax NetworkSetCookieBlockedReason = "SameSiteUnspecifiedTreatedAsLax"

	// NetworkSetCookieBlockedReasonSameSiteNoneInsecure enum const.
	NetworkSetCookieBlockedReasonSameSiteNoneInsecure NetworkSetCookieBlockedReason = "SameSiteNoneInsecure"

	// NetworkSetCookieBlockedReasonUserPreferences enum const.
	NetworkSetCookieBlockedReasonUserPreferences NetworkSetCookieBlockedReason = "UserPreferences"

	// NetworkSetCookieBlockedReasonThirdPartyPhaseout enum const.
	NetworkSetCookieBlockedReasonThirdPartyPhaseout NetworkSetCookieBlockedReason = "ThirdPartyPhaseout"

	// NetworkSetCookieBlockedReasonThirdPartyBlockedInFirstPartySet enum const.
	NetworkSetCookieBlockedReasonThirdPartyBlockedInFirstPartySet NetworkSetCookieBlockedReason = "ThirdPartyBlockedInFirstPartySet"

	// NetworkSetCookieBlockedReasonSyntaxError enum const.
	NetworkSetCookieBlockedReasonSyntaxError NetworkSetCookieBlockedReason = "SyntaxError"

	// NetworkSetCookieBlockedReasonSchemeNotSupported enum const.
	NetworkSetCookieBlockedReasonSchemeNotSupported NetworkSetCookieBlockedReason = "SchemeNotSupported"

	// NetworkSetCookieBlockedReasonOverwriteSecure enum const.
	NetworkSetCookieBlockedReasonOverwriteSecure NetworkSetCookieBlockedReason = "OverwriteSecure"

	// NetworkSetCookieBlockedReasonInvalidDomain enum const.
	NetworkSetCookieBlockedReasonInvalidDomain NetworkSetCookieBlockedReason = "InvalidDomain"

	// NetworkSetCookieBlockedReasonInvalidPrefix enum const.
	NetworkSetCookieBlockedReasonInvalidPrefix NetworkSetCookieBlockedReason = "InvalidPrefix"

	// NetworkSetCookieBlockedReasonUnknownError enum const.
	NetworkSetCookieBlockedReasonUnknownError NetworkSetCookieBlockedReason = "UnknownError"

	// NetworkSetCookieBlockedReasonSchemefulSameSiteStrict enum const.
	NetworkSetCookieBlockedReasonSchemefulSameSiteStrict NetworkSetCookieBlockedReason = "SchemefulSameSiteStrict"

	// NetworkSetCookieBlockedReasonSchemefulSameSiteLax enum const.
	NetworkSetCookieBlockedReasonSchemefulSameSiteLax NetworkSetCookieBlockedReason = "SchemefulSameSiteLax"

	// NetworkSetCookieBlockedReasonSchemefulSameSiteUnspecifiedTreatedAsLax enum const.
	NetworkSetCookieBlockedReasonSchemefulSameSiteUnspecifiedTreatedAsLax NetworkSetCookieBlockedReason = "SchemefulSameSiteUnspecifiedTreatedAsLax"

	// NetworkSetCookieBlockedReasonSamePartyFromCrossPartyContext enum const.
	NetworkSetCookieBlockedReasonSamePartyFromCrossPartyContext NetworkSetCookieBlockedReason = "SamePartyFromCrossPartyContext"

	// NetworkSetCookieBlockedReasonSamePartyConflictsWithOtherAttributes enum const.
	NetworkSetCookieBlockedReasonSamePartyConflictsWithOtherAttributes NetworkSetCookieBlockedReason = "SamePartyConflictsWithOtherAttributes"

	// NetworkSetCookieBlockedReasonNameValuePairExceedsMaxSize enum const.
	NetworkSetCookieBlockedReasonNameValuePairExceedsMaxSize NetworkSetCookieBlockedReason = "NameValuePairExceedsMaxSize"

	// NetworkSetCookieBlockedReasonDisallowedCharacter enum const.
	NetworkSetCookieBlockedReasonDisallowedCharacter NetworkSetCookieBlockedReason = "DisallowedCharacter"

	// NetworkSetCookieBlockedReasonNoCookieContent enum const.
	NetworkSetCookieBlockedReasonNoCookieContent NetworkSetCookieBlockedReason = "NoCookieContent"
)

// NetworkCookieBlockedReason (experimental) Types of reasons why a cookie may not be sent with a request.
type NetworkCookieBlockedReason string

const (
	// NetworkCookieBlockedReasonSecureOnly enum const.
	NetworkCookieBlockedReasonSecureOnly NetworkCookieBlockedReason = "SecureOnly"

	// NetworkCookieBlockedReasonNotOnPath enum const.
	NetworkCookieBlockedReasonNotOnPath NetworkCookieBlockedReason = "NotOnPath"

	// NetworkCookieBlockedReasonDomainMismatch enum const.
	NetworkCookieBlockedReasonDomainMismatch NetworkCookieBlockedReason = "DomainMismatch"

	// NetworkCookieBlockedReasonSameSiteStrict enum const.
	NetworkCookieBlockedReasonSameSiteStrict NetworkCookieBlockedReason = "SameSiteStrict"

	// NetworkCookieBlockedReasonSameSiteLax enum const.
	NetworkCookieBlockedReasonSameSiteLax NetworkCookieBlockedReason = "SameSiteLax"

	// NetworkCookieBlockedReasonSameSiteUnspecifiedTreatedAsLax enum const.
	NetworkCookieBlockedReasonSameSiteUnspecifiedTreatedAsLax NetworkCookieBlockedReason = "SameSiteUnspecifiedTreatedAsLax"

	// NetworkCookieBlockedReasonSameSiteNoneInsecure enum const.
	NetworkCookieBlockedReasonSameSiteNoneInsecure NetworkCookieBlockedReason = "SameSiteNoneInsecure"

	// NetworkCookieBlockedReasonUserPreferences enum const.
	NetworkCookieBlockedReasonUserPreferences NetworkCookieBlockedReason = "UserPreferences"

	// NetworkCookieBlockedReasonThirdPartyPhaseout enum const.
	NetworkCookieBlockedReasonThirdPartyPhaseout NetworkCookieBlockedReason = "ThirdPartyPhaseout"

	// NetworkCookieBlockedReasonThirdPartyBlockedInFirstPartySet enum const.
	NetworkCookieBlockedReasonThirdPartyBlockedInFirstPartySet NetworkCookieBlockedReason = "ThirdPartyBlockedInFirstPartySet"

	// NetworkCookieBlockedReasonUnknownError enum const.
	NetworkCookieBlockedReasonUnknownError NetworkCookieBlockedReason = "UnknownError"

	// NetworkCookieBlockedReasonSchemefulSameSiteStrict enum const.
	NetworkCookieBlockedReasonSchemefulSameSiteStrict NetworkCookieBlockedReason = "SchemefulSameSiteStrict"

	// NetworkCookieBlockedReasonSchemefulSameSiteLax enum const.
	NetworkCookieBlockedReasonSchemefulSameSiteLax NetworkCookieBlockedReason = "SchemefulSameSiteLax"

	// NetworkCookieBlockedReasonSchemefulSameSiteUnspecifiedTreatedAsLax enum const.
	NetworkCookieBlockedReasonSchemefulSameSiteUnspecifiedTreatedAsLax NetworkCookieBlockedReason = "SchemefulSameSiteUnspecifiedTreatedAsLax"

	// NetworkCookieBlockedReasonSamePartyFromCrossPartyContext enum const.
	NetworkCookieBlockedReasonSamePartyFromCrossPartyContext NetworkCookieBlockedReason = "SamePartyFromCrossPartyContext"

	// NetworkCookieBlockedReasonNameValuePairExceedsMaxSize enum const.
	NetworkCookieBlockedReasonNameValuePairExceedsMaxSize NetworkCookieBlockedReason = "NameValuePairExceedsMaxSize"
)

// NetworkCookieExemptionReason (experimental) Types of reasons why a cookie should have been blocked by 3PCD but is exempted for the request.
type NetworkCookieExemptionReason string

const (
	// NetworkCookieExemptionReasonNone enum const.
	NetworkCookieExemptionReasonNone NetworkCookieExemptionReason = "None"

	// NetworkCookieExemptionReasonUserSetting enum const.
	NetworkCookieExemptionReasonUserSetting NetworkCookieExemptionReason = "UserSetting"

	// NetworkCookieExemptionReasonTPCDMetadata enum const.
	NetworkCookieExemptionReasonTPCDMetadata NetworkCookieExemptionReason = "TPCDMetadata"

	// NetworkCookieExemptionReasonTPCDDeprecationTrial enum const.
	NetworkCookieExemptionReasonTPCDDeprecationTrial NetworkCookieExemptionReason = "TPCDDeprecationTrial"

	// NetworkCookieExemptionReasonTPCDHeuristics enum const.
	NetworkCookieExemptionReasonTPCDHeuristics NetworkCookieExemptionReason = "TPCDHeuristics"

	// NetworkCookieExemptionReasonEnterprisePolicy enum const.
	NetworkCookieExemptionReasonEnterprisePolicy NetworkCookieExemptionReason = "EnterprisePolicy"

	// NetworkCookieExemptionReasonStorageAccess enum const.
	NetworkCookieExemptionReasonStorageAccess NetworkCookieExemptionReason = "StorageAccess"

	// NetworkCookieExemptionReasonTopLevelStorageAccess enum const.
	NetworkCookieExemptionReasonTopLevelStorageAccess NetworkCookieExemptionReason = "TopLevelStorageAccess"

	// NetworkCookieExemptionReasonCorsOptIn enum const.
	NetworkCookieExemptionReasonCorsOptIn NetworkCookieExemptionReason = "CorsOptIn"
)

// NetworkBlockedSetCookieWithReason (experimental) A cookie which was not stored from a response with the corresponding reason.
type NetworkBlockedSetCookieWithReason struct {
	// BlockedReasons The reason(s) this cookie was blocked.
	BlockedReasons []NetworkSetCookieBlockedReason `json:"blockedReasons"`

	// CookieLine The string representing this individual cookie as it would appear in the header.
	// This is not the entire "cookie" or "set-cookie" header which could have multiple cookies.
	CookieLine string `json:"cookieLine"`

	// Cookie (optional) The cookie object which represents the cookie which was not stored. It is optional because
	// sometimes complete cookie information is not available, such as in the case of parsing
	// errors.
	Cookie *NetworkCookie `json:"cookie,omitempty"`
}

// NetworkExemptedSetCookieWithReason (experimental) A cookie should have been blocked by 3PCD but is exempted and stored from a response with the
// corresponding reason. A cookie could only have at most one exemption reason.
type NetworkExemptedSetCookieWithReason struct {
	// ExemptionReason The reason the cookie was exempted.
	ExemptionReason NetworkCookieExemptionReason `json:"exemptionReason"`

	// CookieLine The string representing this individual cookie as it would appear in the header.
	CookieLine string `json:"cookieLine"`

	// Cookie The cookie object representing the cookie.
	Cookie *NetworkCookie `json:"cookie"`
}

// NetworkAssociatedCookie (experimental) A cookie associated with the request which may or may not be sent with it.
// Includes the cookies itself and reasons for blocking or exemption.
type NetworkAssociatedCookie struct {
	// Cookie The cookie object representing the cookie which was not sent.
	Cookie *NetworkCookie `json:"cookie"`

	// BlockedReasons The reason(s) the cookie was blocked. If empty means the cookie is included.
	BlockedReasons []NetworkCookieBlockedReason `json:"blockedReasons"`

	// ExemptionReason (optional) The reason the cookie should have been blocked by 3PCD but is exempted. A cookie could
	// only have at most one exemption reason.
	ExemptionReason NetworkCookieExemptionReason `json:"exemptionReason,omitempty"`
}

// NetworkCookieParam Cookie parameter object.
type NetworkCookieParam struct {
	// Name Cookie name.
	Name string `json:"name"`

	// Value Cookie value.
	Value string `json:"value"`

	// URL (optional) The request-URI to associate with the setting of the cookie. This value can affect the
	// default domain, path, source port, and source scheme values of the created cookie.
	URL string `json:"url,omitempty"`

	// Domain (optional) Cookie domain.
	Domain string `json:"domain,omitempty"`

	// Path (optional) Cookie path.
	Path string `json:"path,omitempty"`

	// Secure (optional) True if cookie is secure.
	Secure bool `json:"secure,omitempty"`

	// HTTPOnly (optional) True if cookie is http-only.
	HTTPOnly bool `json:"httpOnly,omitempty"`

	// SameSite (optional) Cookie SameSite type.
	SameSite NetworkCookieSameSite `json:"sameSite,omitempty"`

	// Expires (optional) Cookie expiration date, session cookie if not set
	Expires TimeSinceEpoch `json:"expires,omitempty"`

	// Priority (experimental) (optional) Cookie Priority.
	Priority NetworkCookiePriority `json:"priority,omitempty"`

	// SameParty (experimental) (optional) True if cookie is SameParty.
	SameParty bool `json:"sameParty,omitempty"`

	// SourceScheme (experimental) (optional) Cookie source scheme type.
	SourceScheme NetworkCookieSourceScheme `json:"sourceScheme,omitempty"`

	// SourcePort (experimental) (optional) Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port.
	// An unspecified port value allows protocol clients to emulate legacy cookie scope for the port.
	// This is a temporary ability and it will be removed in the future.
	SourcePort *int `json:"sourcePort,omitempty"`

	// PartitionKey (experimental) (optional) Cookie partition key. The site of the top-level URL the browser was visiting at the start
	// of the request to the endpoint that set the cookie.
	// If not set, the cookie will be set as not partitioned.
	PartitionKey string `json:"partitionKey,omitempty"`
}

// NetworkAuthChallengeSource enum.
type NetworkAuthChallengeSource string

const (
	// NetworkAuthChallengeSourceServer enum const.
	NetworkAuthChallengeSourceServer NetworkAuthChallengeSource = "Server"

	// NetworkAuthChallengeSourceProxy enum const.
	NetworkAuthChallengeSourceProxy NetworkAuthChallengeSource = "Proxy"
)

// NetworkAuthChallenge (experimental) Authorization challenge for HTTP status code 401 or 407.
type NetworkAuthChallenge struct {
	// Source (optional) Source of the authentication challenge.
	Source NetworkAuthChallengeSource `json:"source,omitempty"`

	// Origin of the challenger.
	Origin string `json:"origin"`

	// Scheme The authentication scheme used, such as basic or digest
	Scheme string `json:"scheme"`

	// Realm The realm of the challenge. May be empty.
	Realm string `json:"realm"`
}

// NetworkAuthChallengeResponseResponse enum.
type NetworkAuthChallengeResponseResponse string

const (
	// NetworkAuthChallengeResponseResponseDefault enum const.
	NetworkAuthChallengeResponseResponseDefault NetworkAuthChallengeResponseResponse = "Default"

	// NetworkAuthChallengeResponseResponseCancelAuth enum const.
	NetworkAuthChallengeResponseResponseCancelAuth NetworkAuthChallengeResponseResponse = "CancelAuth"

	// NetworkAuthChallengeResponseResponseProvideCredentials enum const.
	NetworkAuthChallengeResponseResponseProvideCredentials NetworkAuthChallengeResponseResponse = "ProvideCredentials"
)

// NetworkAuthChallengeResponse (experimental) Response to an AuthChallenge.
type NetworkAuthChallengeResponse struct {
	// Response The decision on what to do in response to the authorization challenge.  Default means
	// deferring to the default behavior of the net stack, which will likely either the Cancel
	// authentication or display a popup dialog box.
	Response NetworkAuthChallengeResponseResponse `json:"response"`

	// Username (optional) The username to provide, possibly empty. Should only be set if response is
	// ProvideCredentials.
	Username string `json:"username,omitempty"`

	// Password (optional) The password to provide, possibly empty. Should only be set if response is
	// ProvideCredentials.
	Password string `json:"password,omitempty"`
}

// NetworkInterceptionStage (experimental) Stages of the interception to begin intercepting. Request will intercept before the request is
// sent. Response will intercept after the response is received.
type NetworkInterceptionStage string

const (
	// NetworkInterceptionStageRequest enum const.
	NetworkInterceptionStageRequest NetworkInterceptionStage = "Request"

	// NetworkInterceptionStageHeadersReceived enum const.
	NetworkInterceptionStageHeadersReceived NetworkInterceptionStage = "HeadersReceived"
)

// NetworkRequestPattern (experimental) Request pattern for interception.
type NetworkRequestPattern struct {
	// URLPattern (optional) Wildcards (`'*'` -> zero or more, `'?'` -> exactly one) are allowed. Escape character is
	// backslash. Omitting is equivalent to `"*"`.
	URLPattern string `json:"urlPattern,omitempty"`

	// ResourceType (optional) If set, only requests for matching resource types will be intercepted.
	ResourceType NetworkResourceType `json:"resourceType,omitempty"`

	// InterceptionStage (optional) Stage at which to begin intercepting requests. Default is Request.
	InterceptionStage NetworkInterceptionStage `json:"interceptionStage,omitempty"`
}

// NetworkSignedExchangeSignature (experimental) Information about a signed exchange signature.
// https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#rfc.section.3.1
type NetworkSignedExchangeSignature struct {
	// Label Signed exchange signature label.
	Label string `json:"label"`

	// Signature The hex string of signed exchange signature.
	Signature string `json:"signature"`

	// Integrity Signed exchange signature integrity.
	Integrity string `json:"integrity"`

	// CertURL (optional) Signed exchange signature cert Url.
	CertURL string `json:"certUrl,omitempty"`

	// CertSha256 (optional) The hex string of signed exchange signature cert sha256.
	CertSha256 string `json:"certSha256,omitempty"`

	// ValidityURL Signed exchange signature validity Url.
	ValidityURL string `json:"validityUrl"`

	// Date Signed exchange signature date.
	Date int `json:"date"`

	// Expires Signed exchange signature expires.
	Expires int `json:"expires"`

	// Certificates (optional) The encoded certificates.
	Certificates []string `json:"certificates,omitempty"`
}

// NetworkSignedExchangeHeader (experimental) Information about a signed exchange header.
// https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#cbor-representation
type NetworkSignedExchangeHeader struct {
	// RequestURL Signed exchange request URL.
	RequestURL string `json:"requestUrl"`

	// ResponseCode Signed exchange response code.
	ResponseCode int `json:"responseCode"`

	// ResponseHeaders Signed exchange response headers.
	ResponseHeaders NetworkHeaders `json:"responseHeaders"`

	// Signatures Signed exchange response signature.
	Signatures []*NetworkSignedExchangeSignature `json:"signatures"`

	// HeaderIntegrity Signed exchange header integrity hash in the form of `sha256-<base64-hash-value>`.
	HeaderIntegrity string `json:"headerIntegrity"`
}

// NetworkSignedExchangeErrorField (experimental) Field type for a signed exchange related error.
type NetworkSignedExchangeErrorField string

const (
	// NetworkSignedExchangeErrorFieldSignatureSig enum const.
	NetworkSignedExchangeErrorFieldSignatureSig NetworkSignedExchangeErrorField = "signatureSig"

	// NetworkSignedExchangeErrorFieldSignatureIntegrity enum const.
	NetworkSignedExchangeErrorFieldSignatureIntegrity NetworkSignedExchangeErrorField = "signatureIntegrity"

	// NetworkSignedExchangeErrorFieldSignatureCertURL enum const.
	NetworkSignedExchangeErrorFieldSignatureCertURL NetworkSignedExchangeErrorField = "signatureCertUrl"

	// NetworkSignedExchangeErrorFieldSignatureCertSha256 enum const.
	NetworkSignedExchangeErrorFieldSignatureCertSha256 NetworkSignedExchangeErrorField = "signatureCertSha256"

	// NetworkSignedExchangeErrorFieldSignatureValidityURL enum const.
	NetworkSignedExchangeErrorFieldSignatureValidityURL NetworkSignedExchangeErrorField = "signatureValidityUrl"

	// NetworkSignedExchangeErrorFieldSignatureTimestamps enum const.
	NetworkSignedExchangeErrorFieldSignatureTimestamps NetworkSignedExchangeErrorField = "signatureTimestamps"
)

// NetworkSignedExchangeError (experimental) Information about a signed exchange response.
type NetworkSignedExchangeError struct {
	// Message Error message.
	Message string `json:"message"`

	// SignatureIndex (optional) The index of the signature which caused the error.
	SignatureIndex *int `json:"signatureIndex,omitempty"`

	// ErrorField (optional) The field which caused the error.
	ErrorField NetworkSignedExchangeErrorField `json:"errorField,omitempty"`
}

// NetworkSignedExchangeInfo (experimental) Information about a signed exchange response.
type NetworkSignedExchangeInfo struct {
	// OuterResponse The outer response of signed HTTP exchange which was received from network.
	OuterResponse *NetworkResponse `json:"outerResponse"`

	// Header (optional) Information about the signed exchange header.
	Header *NetworkSignedExchangeHeader `json:"header,omitempty"`

	// SecurityDetails (optional) Security details for the signed exchange header.
	SecurityDetails *NetworkSecurityDetails `json:"securityDetails,omitempty"`

	// Errors (optional) Errors occurred while handling the signed exchange.
	Errors []*NetworkSignedExchangeError `json:"errors,omitempty"`
}

// NetworkContentEncoding (experimental) List of content encodings supported by the backend.
type NetworkContentEncoding string

const (
	// NetworkContentEncodingDeflate enum const.
	NetworkContentEncodingDeflate NetworkContentEncoding = "deflate"

	// NetworkContentEncodingGzip enum const.
	NetworkContentEncodingGzip NetworkContentEncoding = "gzip"

	// NetworkContentEncodingBr enum const.
	NetworkContentEncodingBr NetworkContentEncoding = "br"

	// NetworkContentEncodingZstd enum const.
	NetworkContentEncodingZstd NetworkContentEncoding = "zstd"
)

// NetworkPrivateNetworkRequestPolicy (experimental) ...
type NetworkPrivateNetworkRequestPolicy string

const (
	// NetworkPrivateNetworkRequestPolicyAllow enum const.
	NetworkPrivateNetworkRequestPolicyAllow NetworkPrivateNetworkRequestPolicy = "Allow"

	// NetworkPrivateNetworkRequestPolicyBlockFromInsecureToMorePrivate enum const.
	NetworkPrivateNetworkRequestPolicyBlockFromInsecureToMorePrivate NetworkPrivateNetworkRequestPolicy = "BlockFromInsecureToMorePrivate"

	// NetworkPrivateNetworkRequestPolicyWarnFromInsecureToMorePrivate enum const.
	NetworkPrivateNetworkRequestPolicyWarnFromInsecureToMorePrivate NetworkPrivateNetworkRequestPolicy = "WarnFromInsecureToMorePrivate"

	// NetworkPrivateNetworkRequestPolicyPreflightBlock enum const.
	NetworkPrivateNetworkRequestPolicyPreflightBlock NetworkPrivateNetworkRequestPolicy = "PreflightBlock"

	// NetworkPrivateNetworkRequestPolicyPreflightWarn enum const.
	NetworkPrivateNetworkRequestPolicyPreflightWarn NetworkPrivateNetworkRequestPolicy = "PreflightWarn"
)

// NetworkIPAddressSpace (experimental) ...
type NetworkIPAddressSpace string

const (
	// NetworkIPAddressSpaceLocal enum const.
	NetworkIPAddressSpaceLocal NetworkIPAddressSpace = "Local"

	// NetworkIPAddressSpacePrivate enum const.
	NetworkIPAddressSpacePrivate NetworkIPAddressSpace = "Private"

	// NetworkIPAddressSpacePublic enum const.
	NetworkIPAddressSpacePublic NetworkIPAddressSpace = "Public"

	// NetworkIPAddressSpaceUnknown enum const.
	NetworkIPAddressSpaceUnknown NetworkIPAddressSpace = "Unknown"
)

// NetworkConnectTiming (experimental) ...
type NetworkConnectTiming struct {
	// RequestTime Timing's requestTime is a baseline in seconds, while the other numbers are ticks in
	// milliseconds relatively to this requestTime. Matches ResourceTiming's requestTime for
	// the same request (but not for redirected requests).
	RequestTime float64 `json:"requestTime"`
}

// NetworkClientSecurityState (experimental) ...
type NetworkClientSecurityState struct {
	// InitiatorIsSecureContext ...
	InitiatorIsSecureContext bool `json:"initiatorIsSecureContext"`

	// InitiatorIPAddressSpace ...
	InitiatorIPAddressSpace NetworkIPAddressSpace `json:"initiatorIPAddressSpace"`

	// PrivateNetworkRequestPolicy ...
	PrivateNetworkRequestPolicy NetworkPrivateNetworkRequestPolicy `json:"privateNetworkRequestPolicy"`
}

// NetworkCrossOriginOpenerPolicyValue (experimental) ...
type NetworkCrossOriginOpenerPolicyValue string

const (
	// NetworkCrossOriginOpenerPolicyValueSameOrigin enum const.
	NetworkCrossOriginOpenerPolicyValueSameOrigin NetworkCrossOriginOpenerPolicyValue = "SameOrigin"

	// NetworkCrossOriginOpenerPolicyValueSameOriginAllowPopups enum const.
	NetworkCrossOriginOpenerPolicyValueSameOriginAllowPopups NetworkCrossOriginOpenerPolicyValue = "SameOriginAllowPopups"

	// NetworkCrossOriginOpenerPolicyValueRestrictProperties enum const.
	NetworkCrossOriginOpenerPolicyValueRestrictProperties NetworkCrossOriginOpenerPolicyValue = "RestrictProperties"

	// NetworkCrossOriginOpenerPolicyValueUnsafeNone enum const.
	NetworkCrossOriginOpenerPolicyValueUnsafeNone NetworkCrossOriginOpenerPolicyValue = "UnsafeNone"

	// NetworkCrossOriginOpenerPolicyValueSameOriginPlusCoep enum const.
	NetworkCrossOriginOpenerPolicyValueSameOriginPlusCoep NetworkCrossOriginOpenerPolicyValue = "SameOriginPlusCoep"

	// NetworkCrossOriginOpenerPolicyValueRestrictPropertiesPlusCoep enum const.
	NetworkCrossOriginOpenerPolicyValueRestrictPropertiesPlusCoep NetworkCrossOriginOpenerPolicyValue = "RestrictPropertiesPlusCoep"
)

// NetworkCrossOriginOpenerPolicyStatus (experimental) ...
type NetworkCrossOriginOpenerPolicyStatus struct {
	// Value ...
	Value NetworkCrossOriginOpenerPolicyValue `json:"value"`

	// ReportOnlyValue ...
	ReportOnlyValue NetworkCrossOriginOpenerPolicyValue `json:"reportOnlyValue"`

	// ReportingEndpoint (optional) ...
	ReportingEndpoint string `json:"reportingEndpoint,omitempty"`

	// ReportOnlyReportingEndpoint (optional) ...
	ReportOnlyReportingEndpoint string `json:"reportOnlyReportingEndpoint,omitempty"`
}

// NetworkCrossOriginEmbedderPolicyValue (experimental) ...
type NetworkCrossOriginEmbedderPolicyValue string

const (
	// NetworkCrossOriginEmbedderPolicyValueNone enum const.
	NetworkCrossOriginEmbedderPolicyValueNone NetworkCrossOriginEmbedderPolicyValue = "None"

	// NetworkCrossOriginEmbedderPolicyValueCredentialless enum const.
	NetworkCrossOriginEmbedderPolicyValueCredentialless NetworkCrossOriginEmbedderPolicyValue = "Credentialless"

	// NetworkCrossOriginEmbedderPolicyValueRequireCorp enum const.
	NetworkCrossOriginEmbedderPolicyValueRequireCorp NetworkCrossOriginEmbedderPolicyValue = "RequireCorp"
)

// NetworkCrossOriginEmbedderPolicyStatus (experimental) ...
type NetworkCrossOriginEmbedderPolicyStatus struct {
	// Value ...
	Value NetworkCrossOriginEmbedderPolicyValue `json:"value"`

	// ReportOnlyValue ...
	ReportOnlyValue NetworkCrossOriginEmbedderPolicyValue `json:"reportOnlyValue"`

	// ReportingEndpoint (optional) ...
	ReportingEndpoint string `json:"reportingEndpoint,omitempty"`

	// ReportOnlyReportingEndpoint (optional) ...
	ReportOnlyReportingEndpoint string `json:"reportOnlyReportingEndpoint,omitempty"`
}

// NetworkContentSecurityPolicySource (experimental) ...
type NetworkContentSecurityPolicySource string

const (
	// NetworkContentSecurityPolicySourceHTTP enum const.
	NetworkContentSecurityPolicySourceHTTP NetworkContentSecurityPolicySource = "HTTP"

	// NetworkContentSecurityPolicySourceMeta enum const.
	NetworkContentSecurityPolicySourceMeta NetworkContentSecurityPolicySource = "Meta"
)

// NetworkContentSecurityPolicyStatus (experimental) ...
type NetworkContentSecurityPolicyStatus struct {
	// EffectiveDirectives ...
	EffectiveDirectives string `json:"effectiveDirectives"`

	// IsEnforced ...
	IsEnforced bool `json:"isEnforced"`

	// Source ...
	Source NetworkContentSecurityPolicySource `json:"source"`
}

// NetworkSecurityIsolationStatus (experimental) ...
type NetworkSecurityIsolationStatus struct {
	// Coop (optional) ...
	Coop *NetworkCrossOriginOpenerPolicyStatus `json:"coop,omitempty"`

	// Coep (optional) ...
	Coep *NetworkCrossOriginEmbedderPolicyStatus `json:"coep,omitempty"`

	// Csp (optional) ...
	Csp []*NetworkContentSecurityPolicyStatus `json:"csp,omitempty"`
}

// NetworkReportStatus (experimental) The status of a Reporting API report.
type NetworkReportStatus string

const (
	// NetworkReportStatusQueued enum const.
	NetworkReportStatusQueued NetworkReportStatus = "Queued"

	// NetworkReportStatusPending enum const.
	NetworkReportStatusPending NetworkReportStatus = "Pending"

	// NetworkReportStatusMarkedForRemoval enum const.
	NetworkReportStatusMarkedForRemoval NetworkReportStatus = "MarkedForRemoval"

	// NetworkReportStatusSuccess enum const.
	NetworkReportStatusSuccess NetworkReportStatus = "Success"
)

// NetworkReportID (experimental) ...
type NetworkReportID string

// NetworkReportingAPIReport (experimental) An object representing a report generated by the Reporting API.
type NetworkReportingAPIReport struct {
	// ID ...
	ID NetworkReportID `json:"id"`

	// InitiatorURL The URL of the document that triggered the report.
	InitiatorURL string `json:"initiatorUrl"`

	// Destination The name of the endpoint group that should be used to deliver the report.
	Destination string `json:"destination"`

	// Type The type of the report (specifies the set of data that is contained in the report body).
	Type string `json:"type"`

	// Timestamp When the report was generated.
	Timestamp TimeSinceEpoch `json:"timestamp"`

	// Depth How many uploads deep the related request was.
	Depth int `json:"depth"`

	// CompletedAttempts The number of delivery attempts made so far, not including an active attempt.
	CompletedAttempts int `json:"completedAttempts"`

	// Body ...
	Body map[string]gson.JSON `json:"body"`

	// Status ...
	Status NetworkReportStatus `json:"status"`
}

// NetworkReportingAPIEndpoint (experimental) ...
type NetworkReportingAPIEndpoint struct {
	// URL The URL of the endpoint to which reports may be delivered.
	URL string `json:"url"`

	// GroupName Name of the endpoint group.
	GroupName string `json:"groupName"`
}

// NetworkLoadNetworkResourcePageResult (experimental) An object providing the result of a network resource load.
type NetworkLoadNetworkResourcePageResult struct {
	// Success ...
	Success bool `json:"success"`

	// NetError (optional) Optional values used for error reporting.
	NetError *float64 `json:"netError,omitempty"`

	// NetErrorName (optional) ...
	NetErrorName string `json:"netErrorName,omitempty"`

	// HTTPStatusCode (optional) ...
	HTTPStatusCode *float64 `json:"httpStatusCode,omitempty"`

	// Stream (optional) If successful, one of the following two fields holds the result.
	Stream IOStreamHandle `json:"stream,omitempty"`

	// Headers (optional) Response headers.
	Headers NetworkHeaders `json:"headers,omitempty"`
}

// NetworkLoadNetworkResourceOptions (experimental) An options object that may be extended later to better support CORS,
// CORB and streaming.
type NetworkLoadNetworkResourceOptions struct {
	// DisableCache ...
	DisableCache bool `json:"disableCache"`

	// IncludeCredentials ...
	IncludeCredentials bool `json:"includeCredentials"`
}

// NetworkSetAcceptedEncodings (experimental) Sets a list of content encodings that will be accepted. Empty list means no encoding is accepted.
type NetworkSetAcceptedEncodings struct {
	// Encodings List of accepted content encodings.
	Encodings []NetworkContentEncoding `json:"encodings"`
}

// ProtoReq name.
func (m NetworkSetAcceptedEncodings) ProtoReq() string { return "Network.setAcceptedEncodings" }

// Call sends the request.
func (m NetworkSetAcceptedEncodings) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkClearAcceptedEncodingsOverride (experimental) Clears accepted encodings set by setAcceptedEncodings.
type NetworkClearAcceptedEncodingsOverride struct{}

// ProtoReq name.
func (m NetworkClearAcceptedEncodingsOverride) ProtoReq() string {
	return "Network.clearAcceptedEncodingsOverride"
}

// Call sends the request.
func (m NetworkClearAcceptedEncodingsOverride) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkCanClearBrowserCache (deprecated) Tells whether clearing browser cache is supported.
type NetworkCanClearBrowserCache struct{}

// ProtoReq name.
func (m NetworkCanClearBrowserCache) ProtoReq() string { return "Network.canClearBrowserCache" }

// Call the request.
func (m NetworkCanClearBrowserCache) Call(c Client) (*NetworkCanClearBrowserCacheResult, error) {
	var res NetworkCanClearBrowserCacheResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkCanClearBrowserCacheResult (deprecated) ...
type NetworkCanClearBrowserCacheResult struct {
	// Result True if browser cache can be cleared.
	Result bool `json:"result"`
}

// NetworkCanClearBrowserCookies (deprecated) Tells whether clearing browser cookies is supported.
type NetworkCanClearBrowserCookies struct{}

// ProtoReq name.
func (m NetworkCanClearBrowserCookies) ProtoReq() string { return "Network.canClearBrowserCookies" }

// Call the request.
func (m NetworkCanClearBrowserCookies) Call(c Client) (*NetworkCanClearBrowserCookiesResult, error) {
	var res NetworkCanClearBrowserCookiesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkCanClearBrowserCookiesResult (deprecated) ...
type NetworkCanClearBrowserCookiesResult struct {
	// Result True if browser cookies can be cleared.
	Result bool `json:"result"`
}

// NetworkCanEmulateNetworkConditions (deprecated) Tells whether emulation of network conditions is supported.
type NetworkCanEmulateNetworkConditions struct{}

// ProtoReq name.
func (m NetworkCanEmulateNetworkConditions) ProtoReq() string {
	return "Network.canEmulateNetworkConditions"
}

// Call the request.
func (m NetworkCanEmulateNetworkConditions) Call(c Client) (*NetworkCanEmulateNetworkConditionsResult, error) {
	var res NetworkCanEmulateNetworkConditionsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkCanEmulateNetworkConditionsResult (deprecated) ...
type NetworkCanEmulateNetworkConditionsResult struct {
	// Result True if emulation of network conditions is supported.
	Result bool `json:"result"`
}

// NetworkClearBrowserCache Clears browser cache.
type NetworkClearBrowserCache struct{}

// ProtoReq name.
func (m NetworkClearBrowserCache) ProtoReq() string { return "Network.clearBrowserCache" }

// Call sends the request.
func (m NetworkClearBrowserCache) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkClearBrowserCookies Clears browser cookies.
type NetworkClearBrowserCookies struct{}

// ProtoReq name.
func (m NetworkClearBrowserCookies) ProtoReq() string { return "Network.clearBrowserCookies" }

// Call sends the request.
func (m NetworkClearBrowserCookies) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkContinueInterceptedRequest (deprecated) (experimental) Response to Network.requestIntercepted which either modifies the request to continue with any
// modifications, or blocks it, or completes it with the provided response bytes. If a network
// fetch occurs as a result which encounters a redirect an additional Network.requestIntercepted
// event will be sent with the same InterceptionId.
// Deprecated, use Fetch.continueRequest, Fetch.fulfillRequest and Fetch.failRequest instead.
type NetworkContinueInterceptedRequest struct {
	// InterceptionID ...
	InterceptionID NetworkInterceptionID `json:"interceptionId"`

	// ErrorReason (optional) If set this causes the request to fail with the given reason. Passing `Aborted` for requests
	// marked with `isNavigationRequest` also cancels the navigation. Must not be set in response
	// to an authChallenge.
	ErrorReason NetworkErrorReason `json:"errorReason,omitempty"`

	// RawResponse (optional) If set the requests completes using with the provided base64 encoded raw response, including
	// HTTP status line and headers etc... Must not be set in response to an authChallenge.
	RawResponse []byte `json:"rawResponse,omitempty"`

	// URL (optional) If set the request url will be modified in a way that's not observable by page. Must not be
	// set in response to an authChallenge.
	URL string `json:"url,omitempty"`

	// Method (optional) If set this allows the request method to be overridden. Must not be set in response to an
	// authChallenge.
	Method string `json:"method,omitempty"`

	// PostData (optional) If set this allows postData to be set. Must not be set in response to an authChallenge.
	PostData string `json:"postData,omitempty"`

	// Headers (optional) If set this allows the request headers to be changed. Must not be set in response to an
	// authChallenge.
	Headers NetworkHeaders `json:"headers,omitempty"`

	// AuthChallengeResponse (optional) Response to a requestIntercepted with an authChallenge. Must not be set otherwise.
	AuthChallengeResponse *NetworkAuthChallengeResponse `json:"authChallengeResponse,omitempty"`
}

// ProtoReq name.
func (m NetworkContinueInterceptedRequest) ProtoReq() string {
	return "Network.continueInterceptedRequest"
}

// Call sends the request.
func (m NetworkContinueInterceptedRequest) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkDeleteCookies Deletes browser cookies with matching name and url or domain/path/partitionKey pair.
type NetworkDeleteCookies struct {
	// Name of the cookies to remove.
	Name string `json:"name"`

	// URL (optional) If specified, deletes all the cookies with the given name where domain and path match
	// provided URL.
	URL string `json:"url,omitempty"`

	// Domain (optional) If specified, deletes only cookies with the exact domain.
	Domain string `json:"domain,omitempty"`

	// Path (optional) If specified, deletes only cookies with the exact path.
	Path string `json:"path,omitempty"`

	// PartitionKey (optional) If specified, deletes only cookies with the the given name and partitionKey where domain
	// matches provided URL.
	PartitionKey string `json:"partitionKey,omitempty"`
}

// ProtoReq name.
func (m NetworkDeleteCookies) ProtoReq() string { return "Network.deleteCookies" }

// Call sends the request.
func (m NetworkDeleteCookies) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkDisable Disables network tracking, prevents network events from being sent to the client.
type NetworkDisable struct{}

// ProtoReq name.
func (m NetworkDisable) ProtoReq() string { return "Network.disable" }

// Call sends the request.
func (m NetworkDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkEmulateNetworkConditions Activates emulation of network conditions.
type NetworkEmulateNetworkConditions struct {
	// Offline True to emulate internet disconnection.
	Offline bool `json:"offline"`

	// Latency Minimum latency from request sent to response headers received (ms).
	Latency float64 `json:"latency"`

	// DownloadThroughput Maximal aggregated download throughput (bytes/sec). -1 disables download throttling.
	DownloadThroughput float64 `json:"downloadThroughput"`

	// UploadThroughput Maximal aggregated upload throughput (bytes/sec).  -1 disables upload throttling.
	UploadThroughput float64 `json:"uploadThroughput"`

	// ConnectionType (optional) Connection type if known.
	ConnectionType NetworkConnectionType `json:"connectionType,omitempty"`

	// PacketLoss (experimental) (optional) WebRTC packet loss (percent, 0-100). 0 disables packet loss emulation, 100 drops all the packets.
	PacketLoss *float64 `json:"packetLoss,omitempty"`

	// PacketQueueLength (experimental) (optional) WebRTC packet queue length (packet). 0 removes any queue length limitations.
	PacketQueueLength *int `json:"packetQueueLength,omitempty"`

	// PacketReordering (experimental) (optional) WebRTC packetReordering feature.
	PacketReordering bool `json:"packetReordering,omitempty"`
}

// ProtoReq name.
func (m NetworkEmulateNetworkConditions) ProtoReq() string { return "Network.emulateNetworkConditions" }

// Call sends the request.
func (m NetworkEmulateNetworkConditions) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkEnable Enables network tracking, network events will now be delivered to the client.
type NetworkEnable struct {
	// MaxTotalBufferSize (experimental) (optional) Buffer size in bytes to use when preserving network payloads (XHRs, etc).
	MaxTotalBufferSize *int `json:"maxTotalBufferSize,omitempty"`

	// MaxResourceBufferSize (experimental) (optional) Per-resource buffer size in bytes to use when preserving network payloads (XHRs, etc).
	MaxResourceBufferSize *int `json:"maxResourceBufferSize,omitempty"`

	// MaxPostDataSize (optional) Longest post body size (in bytes) that would be included in requestWillBeSent notification
	MaxPostDataSize *int `json:"maxPostDataSize,omitempty"`
}

// ProtoReq name.
func (m NetworkEnable) ProtoReq() string { return "Network.enable" }

// Call sends the request.
func (m NetworkEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkGetAllCookies (deprecated) Returns all browser cookies. Depending on the backend support, will return detailed cookie
// information in the `cookies` field.
// Deprecated. Use Storage.getCookies instead.
type NetworkGetAllCookies struct{}

// ProtoReq name.
func (m NetworkGetAllCookies) ProtoReq() string { return "Network.getAllCookies" }

// Call the request.
func (m NetworkGetAllCookies) Call(c Client) (*NetworkGetAllCookiesResult, error) {
	var res NetworkGetAllCookiesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkGetAllCookiesResult (deprecated) ...
type NetworkGetAllCookiesResult struct {
	// Cookies Array of cookie objects.
	Cookies []*NetworkCookie `json:"cookies"`
}

// NetworkGetCertificate (experimental) Returns the DER-encoded certificate.
type NetworkGetCertificate struct {
	// Origin to get certificate for.
	Origin string `json:"origin"`
}

// ProtoReq name.
func (m NetworkGetCertificate) ProtoReq() string { return "Network.getCertificate" }

// Call the request.
func (m NetworkGetCertificate) Call(c Client) (*NetworkGetCertificateResult, error) {
	var res NetworkGetCertificateResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkGetCertificateResult (experimental) ...
type NetworkGetCertificateResult struct {
	// TableNames ...
	TableNames []string `json:"tableNames"`
}

// NetworkGetCookies Returns all browser cookies for the current URL. Depending on the backend support, will return
// detailed cookie information in the `cookies` field.
type NetworkGetCookies struct {
	// Urls (optional) The list of URLs for which applicable cookies will be fetched.
	// If not specified, it's assumed to be set to the list containing
	// the URLs of the page and all of its subframes.
	Urls []string `json:"urls,omitempty"`
}

// ProtoReq name.
func (m NetworkGetCookies) ProtoReq() string { return "Network.getCookies" }

// Call the request.
func (m NetworkGetCookies) Call(c Client) (*NetworkGetCookiesResult, error) {
	var res NetworkGetCookiesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkGetCookiesResult ...
type NetworkGetCookiesResult struct {
	// Cookies Array of cookie objects.
	Cookies []*NetworkCookie `json:"cookies"`
}

// NetworkGetResponseBody Returns content served for the given request.
type NetworkGetResponseBody struct {
	// RequestID Identifier of the network request to get content for.
	RequestID NetworkRequestID `json:"requestId"`
}

// ProtoReq name.
func (m NetworkGetResponseBody) ProtoReq() string { return "Network.getResponseBody" }

// Call the request.
func (m NetworkGetResponseBody) Call(c Client) (*NetworkGetResponseBodyResult, error) {
	var res NetworkGetResponseBodyResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkGetResponseBodyResult ...
type NetworkGetResponseBodyResult struct {
	// Body Response body.
	Body string `json:"body"`

	// Base64Encoded True, if content was sent as base64.
	Base64Encoded bool `json:"base64Encoded"`
}

// NetworkGetRequestPostData Returns post data sent with the request. Returns an error when no data was sent with the request.
type NetworkGetRequestPostData struct {
	// RequestID Identifier of the network request to get content for.
	RequestID NetworkRequestID `json:"requestId"`
}

// ProtoReq name.
func (m NetworkGetRequestPostData) ProtoReq() string { return "Network.getRequestPostData" }

// Call the request.
func (m NetworkGetRequestPostData) Call(c Client) (*NetworkGetRequestPostDataResult, error) {
	var res NetworkGetRequestPostDataResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkGetRequestPostDataResult ...
type NetworkGetRequestPostDataResult struct {
	// PostData Request body string, omitting files from multipart requests
	PostData string `json:"postData"`
}

// NetworkGetResponseBodyForInterception (experimental) Returns content served for the given currently intercepted request.
type NetworkGetResponseBodyForInterception struct {
	// InterceptionID Identifier for the intercepted request to get body for.
	InterceptionID NetworkInterceptionID `json:"interceptionId"`
}

// ProtoReq name.
func (m NetworkGetResponseBodyForInterception) ProtoReq() string {
	return "Network.getResponseBodyForInterception"
}

// Call the request.
func (m NetworkGetResponseBodyForInterception) Call(c Client) (*NetworkGetResponseBodyForInterceptionResult, error) {
	var res NetworkGetResponseBodyForInterceptionResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkGetResponseBodyForInterceptionResult (experimental) ...
type NetworkGetResponseBodyForInterceptionResult struct {
	// Body Response body.
	Body string `json:"body"`

	// Base64Encoded True, if content was sent as base64.
	Base64Encoded bool `json:"base64Encoded"`
}

// NetworkTakeResponseBodyForInterceptionAsStream (experimental) Returns a handle to the stream representing the response body. Note that after this command,
// the intercepted request can't be continued as is -- you either need to cancel it or to provide
// the response body. The stream only supports sequential read, IO.read will fail if the position
// is specified.
type NetworkTakeResponseBodyForInterceptionAsStream struct {
	// InterceptionID ...
	InterceptionID NetworkInterceptionID `json:"interceptionId"`
}

// ProtoReq name.
func (m NetworkTakeResponseBodyForInterceptionAsStream) ProtoReq() string {
	return "Network.takeResponseBodyForInterceptionAsStream"
}

// Call the request.
func (m NetworkTakeResponseBodyForInterceptionAsStream) Call(c Client) (*NetworkTakeResponseBodyForInterceptionAsStreamResult, error) {
	var res NetworkTakeResponseBodyForInterceptionAsStreamResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkTakeResponseBodyForInterceptionAsStreamResult (experimental) ...
type NetworkTakeResponseBodyForInterceptionAsStreamResult struct {
	// Stream ...
	Stream IOStreamHandle `json:"stream"`
}

// NetworkReplayXHR (experimental) This method sends a new XMLHttpRequest which is identical to the original one. The following
// parameters should be identical: method, url, async, request body, extra headers, withCredentials
// attribute, user, password.
type NetworkReplayXHR struct {
	// RequestID Identifier of XHR to replay.
	RequestID NetworkRequestID `json:"requestId"`
}

// ProtoReq name.
func (m NetworkReplayXHR) ProtoReq() string { return "Network.replayXHR" }

// Call sends the request.
func (m NetworkReplayXHR) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkSearchInResponseBody (experimental) Searches for given string in response content.
type NetworkSearchInResponseBody struct {
	// RequestID Identifier of the network response to search.
	RequestID NetworkRequestID `json:"requestId"`

	// Query String to search for.
	Query string `json:"query"`

	// CaseSensitive (optional) If true, search is case sensitive.
	CaseSensitive bool `json:"caseSensitive,omitempty"`

	// IsRegex (optional) If true, treats string parameter as regex.
	IsRegex bool `json:"isRegex,omitempty"`
}

// ProtoReq name.
func (m NetworkSearchInResponseBody) ProtoReq() string { return "Network.searchInResponseBody" }

// Call the request.
func (m NetworkSearchInResponseBody) Call(c Client) (*NetworkSearchInResponseBodyResult, error) {
	var res NetworkSearchInResponseBodyResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkSearchInResponseBodyResult (experimental) ...
type NetworkSearchInResponseBodyResult struct {
	// Result List of search matches.
	Result []*DebuggerSearchMatch `json:"result"`
}

// NetworkSetBlockedURLs (experimental) Blocks URLs from loading.
type NetworkSetBlockedURLs struct {
	// Urls URL patterns to block. Wildcards ('*') are allowed.
	Urls []string `json:"urls"`
}

// ProtoReq name.
func (m NetworkSetBlockedURLs) ProtoReq() string { return "Network.setBlockedURLs" }

// Call sends the request.
func (m NetworkSetBlockedURLs) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkSetBypassServiceWorker Toggles ignoring of service worker for each request.
type NetworkSetBypassServiceWorker struct {
	// Bypass service worker and load from network.
	Bypass bool `json:"bypass"`
}

// ProtoReq name.
func (m NetworkSetBypassServiceWorker) ProtoReq() string { return "Network.setBypassServiceWorker" }

// Call sends the request.
func (m NetworkSetBypassServiceWorker) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkSetCacheDisabled Toggles ignoring cache for each request. If `true`, cache will not be used.
type NetworkSetCacheDisabled struct {
	// CacheDisabled Cache disabled state.
	CacheDisabled bool `json:"cacheDisabled"`
}

// ProtoReq name.
func (m NetworkSetCacheDisabled) ProtoReq() string { return "Network.setCacheDisabled" }

// Call sends the request.
func (m NetworkSetCacheDisabled) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkSetCookie Sets a cookie with the given cookie data; may overwrite equivalent cookies if they exist.
type NetworkSetCookie struct {
	// Name Cookie name.
	Name string `json:"name"`

	// Value Cookie value.
	Value string `json:"value"`

	// URL (optional) The request-URI to associate with the setting of the cookie. This value can affect the
	// default domain, path, source port, and source scheme values of the created cookie.
	URL string `json:"url,omitempty"`

	// Domain (optional) Cookie domain.
	Domain string `json:"domain,omitempty"`

	// Path (optional) Cookie path.
	Path string `json:"path,omitempty"`

	// Secure (optional) True if cookie is secure.
	Secure bool `json:"secure,omitempty"`

	// HTTPOnly (optional) True if cookie is http-only.
	HTTPOnly bool `json:"httpOnly,omitempty"`

	// SameSite (optional) Cookie SameSite type.
	SameSite NetworkCookieSameSite `json:"sameSite,omitempty"`

	// Expires (optional) Cookie expiration date, session cookie if not set
	Expires TimeSinceEpoch `json:"expires,omitempty"`

	// Priority (experimental) (optional) Cookie Priority type.
	Priority NetworkCookiePriority `json:"priority,omitempty"`

	// SameParty (experimental) (optional) True if cookie is SameParty.
	SameParty bool `json:"sameParty,omitempty"`

	// SourceScheme (experimental) (optional) Cookie source scheme type.
	SourceScheme NetworkCookieSourceScheme `json:"sourceScheme,omitempty"`

	// SourcePort (experimental) (optional) Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port.
	// An unspecified port value allows protocol clients to emulate legacy cookie scope for the port.
	// This is a temporary ability and it will be removed in the future.
	SourcePort *int `json:"sourcePort,omitempty"`

	// PartitionKey (experimental) (optional) Cookie partition key. The site of the top-level URL the browser was visiting at the start
	// of the request to the endpoint that set the cookie.
	// If not set, the cookie will be set as not partitioned.
	PartitionKey string `json:"partitionKey,omitempty"`
}

// ProtoReq name.
func (m NetworkSetCookie) ProtoReq() string { return "Network.setCookie" }

// Call the request.
func (m NetworkSetCookie) Call(c Client) (*NetworkSetCookieResult, error) {
	var res NetworkSetCookieResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkSetCookieResult ...
type NetworkSetCookieResult struct {
	// Success (deprecated) Always set to true. If an error occurs, the response indicates protocol error.
	Success bool `json:"success"`
}

// NetworkSetCookies Sets given cookies.
type NetworkSetCookies struct {
	// Cookies to be set.
	Cookies []*NetworkCookieParam `json:"cookies"`
}

// ProtoReq name.
func (m NetworkSetCookies) ProtoReq() string { return "Network.setCookies" }

// Call sends the request.
func (m NetworkSetCookies) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkSetExtraHTTPHeaders Specifies whether to always send extra HTTP headers with the requests from this page.
type NetworkSetExtraHTTPHeaders struct {
	// Headers Map with extra HTTP headers.
	Headers NetworkHeaders `json:"headers"`
}

// ProtoReq name.
func (m NetworkSetExtraHTTPHeaders) ProtoReq() string { return "Network.setExtraHTTPHeaders" }

// Call sends the request.
func (m NetworkSetExtraHTTPHeaders) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkSetAttachDebugStack (experimental) Specifies whether to attach a page script stack id in requests.
type NetworkSetAttachDebugStack struct {
	// Enabled Whether to attach a page script stack for debugging purpose.
	Enabled bool `json:"enabled"`
}

// ProtoReq name.
func (m NetworkSetAttachDebugStack) ProtoReq() string { return "Network.setAttachDebugStack" }

// Call sends the request.
func (m NetworkSetAttachDebugStack) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkSetRequestInterception (deprecated) (experimental) Sets the requests to intercept that match the provided patterns and optionally resource types.
// Deprecated, please use Fetch.enable instead.
type NetworkSetRequestInterception struct {
	// Patterns Requests matching any of these patterns will be forwarded and wait for the corresponding
	// continueInterceptedRequest call.
	Patterns []*NetworkRequestPattern `json:"patterns"`
}

// ProtoReq name.
func (m NetworkSetRequestInterception) ProtoReq() string { return "Network.setRequestInterception" }

// Call sends the request.
func (m NetworkSetRequestInterception) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkSetUserAgentOverride Allows overriding user agent with the given string.
type NetworkSetUserAgentOverride struct {
	// UserAgent User agent to use.
	UserAgent string `json:"userAgent"`

	// AcceptLanguage (optional) Browser language to emulate.
	AcceptLanguage string `json:"acceptLanguage,omitempty"`

	// Platform (optional) The platform navigator.platform should return.
	Platform string `json:"platform,omitempty"`

	// UserAgentMetadata (experimental) (optional) To be sent in Sec-CH-UA-* headers and returned in navigator.userAgentData
	UserAgentMetadata *EmulationUserAgentMetadata `json:"userAgentMetadata,omitempty"`
}

// ProtoReq name.
func (m NetworkSetUserAgentOverride) ProtoReq() string { return "Network.setUserAgentOverride" }

// Call sends the request.
func (m NetworkSetUserAgentOverride) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkStreamResourceContent (experimental) Enables streaming of the response for the given requestId.
// If enabled, the dataReceived event contains the data that was received during streaming.
type NetworkStreamResourceContent struct {
	// RequestID Identifier of the request to stream.
	RequestID NetworkRequestID `json:"requestId"`
}

// ProtoReq name.
func (m NetworkStreamResourceContent) ProtoReq() string { return "Network.streamResourceContent" }

// Call the request.
func (m NetworkStreamResourceContent) Call(c Client) (*NetworkStreamResourceContentResult, error) {
	var res NetworkStreamResourceContentResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkStreamResourceContentResult (experimental) ...
type NetworkStreamResourceContentResult struct {
	// BufferedData Data that has been buffered until streaming is enabled.
	BufferedData []byte `json:"bufferedData"`
}

// NetworkGetSecurityIsolationStatus (experimental) Returns information about the COEP/COOP isolation status.
type NetworkGetSecurityIsolationStatus struct {
	// FrameID (optional) If no frameId is provided, the status of the target is provided.
	FrameID PageFrameID `json:"frameId,omitempty"`
}

// ProtoReq name.
func (m NetworkGetSecurityIsolationStatus) ProtoReq() string {
	return "Network.getSecurityIsolationStatus"
}

// Call the request.
func (m NetworkGetSecurityIsolationStatus) Call(c Client) (*NetworkGetSecurityIsolationStatusResult, error) {
	var res NetworkGetSecurityIsolationStatusResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkGetSecurityIsolationStatusResult (experimental) ...
type NetworkGetSecurityIsolationStatusResult struct {
	// Status ...
	Status *NetworkSecurityIsolationStatus `json:"status"`
}

// NetworkEnableReportingAPI (experimental) Enables tracking for the Reporting API, events generated by the Reporting API will now be delivered to the client.
// Enabling triggers 'reportingApiReportAdded' for all existing reports.
type NetworkEnableReportingAPI struct {
	// Enable Whether to enable or disable events for the Reporting API
	Enable bool `json:"enable"`
}

// ProtoReq name.
func (m NetworkEnableReportingAPI) ProtoReq() string { return "Network.enableReportingApi" }

// Call sends the request.
func (m NetworkEnableReportingAPI) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// NetworkLoadNetworkResource (experimental) Fetches the resource and returns the content.
type NetworkLoadNetworkResource struct {
	// FrameID (optional) Frame id to get the resource for. Mandatory for frame targets, and
	// should be omitted for worker targets.
	FrameID PageFrameID `json:"frameId,omitempty"`

	// URL of the resource to get content for.
	URL string `json:"url"`

	// Options for the request.
	Options *NetworkLoadNetworkResourceOptions `json:"options"`
}

// ProtoReq name.
func (m NetworkLoadNetworkResource) ProtoReq() string { return "Network.loadNetworkResource" }

// Call the request.
func (m NetworkLoadNetworkResource) Call(c Client) (*NetworkLoadNetworkResourceResult, error) {
	var res NetworkLoadNetworkResourceResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// NetworkLoadNetworkResourceResult (experimental) ...
type NetworkLoadNetworkResourceResult struct {
	// Resource ...
	Resource *NetworkLoadNetworkResourcePageResult `json:"resource"`
}

// NetworkDataReceived Fired when data chunk was received over the network.
type NetworkDataReceived struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// DataLength Data chunk length.
	DataLength int `json:"dataLength"`

	// EncodedDataLength Actual bytes received (might be less than dataLength for compressed encodings).
	EncodedDataLength int `json:"encodedDataLength"`

	// Data (experimental) (optional) Data that was received.
	Data []byte `json:"data,omitempty"`
}

// ProtoEvent name.
func (evt NetworkDataReceived) ProtoEvent() string {
	return "Network.dataReceived"
}

// NetworkEventSourceMessageReceived Fired when EventSource message is received.
type NetworkEventSourceMessageReceived struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// EventName Message type.
	EventName string `json:"eventName"`

	// EventID Message identifier.
	EventID string `json:"eventId"`

	// Data Message content.
	Data string `json:"data"`
}

// ProtoEvent name.
func (evt NetworkEventSourceMessageReceived) ProtoEvent() string {
	return "Network.eventSourceMessageReceived"
}

// NetworkLoadingFailed Fired when HTTP request has failed to load.
type NetworkLoadingFailed struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// Type Resource type.
	Type NetworkResourceType `json:"type"`

	// ErrorText Error message. List of network errors: https://cs.chromium.org/chromium/src/net/base/net_error_list.h
	ErrorText string `json:"errorText"`

	// Canceled (optional) True if loading was canceled.
	Canceled bool `json:"canceled,omitempty"`

	// BlockedReason (optional) The reason why loading was blocked, if any.
	BlockedReason NetworkBlockedReason `json:"blockedReason,omitempty"`

	// CorsErrorStatus (optional) The reason why loading was blocked by CORS, if any.
	CorsErrorStatus *NetworkCorsErrorStatus `json:"corsErrorStatus,omitempty"`
}

// ProtoEvent name.
func (evt NetworkLoadingFailed) ProtoEvent() string {
	return "Network.loadingFailed"
}

// NetworkLoadingFinished Fired when HTTP request has finished loading.
type NetworkLoadingFinished struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// EncodedDataLength Total number of bytes received for this request.
	EncodedDataLength float64 `json:"encodedDataLength"`
}

// ProtoEvent name.
func (evt NetworkLoadingFinished) ProtoEvent() string {
	return "Network.loadingFinished"
}

// NetworkRequestIntercepted (deprecated) (experimental) Details of an intercepted HTTP request, which must be either allowed, blocked, modified or
// mocked.
// Deprecated, use Fetch.requestPaused instead.
type NetworkRequestIntercepted struct {
	// InterceptionID Each request the page makes will have a unique id, however if any redirects are encountered
	// while processing that fetch, they will be reported with the same id as the original fetch.
	// Likewise if HTTP authentication is needed then the same fetch id will be used.
	InterceptionID NetworkInterceptionID `json:"interceptionId"`

	// Request ...
	Request *NetworkRequest `json:"request"`

	// FrameID The id of the frame that initiated the request.
	FrameID PageFrameID `json:"frameId"`

	// ResourceType How the requested resource will be used.
	ResourceType NetworkResourceType `json:"resourceType"`

	// IsNavigationRequest Whether this is a navigation request, which can abort the navigation completely.
	IsNavigationRequest bool `json:"isNavigationRequest"`

	// IsDownload (optional) Set if the request is a navigation that will result in a download.
	// Only present after response is received from the server (i.e. HeadersReceived stage).
	IsDownload bool `json:"isDownload,omitempty"`

	// RedirectURL (optional) Redirect location, only sent if a redirect was intercepted.
	RedirectURL string `json:"redirectUrl,omitempty"`

	// AuthChallenge (optional) Details of the Authorization Challenge encountered. If this is set then
	// continueInterceptedRequest must contain an authChallengeResponse.
	AuthChallenge *NetworkAuthChallenge `json:"authChallenge,omitempty"`

	// ResponseErrorReason (optional) Response error if intercepted at response stage or if redirect occurred while intercepting
	// request.
	ResponseErrorReason NetworkErrorReason `json:"responseErrorReason,omitempty"`

	// ResponseStatusCode (optional) Response code if intercepted at response stage or if redirect occurred while intercepting
	// request or auth retry occurred.
	ResponseStatusCode *int `json:"responseStatusCode,omitempty"`

	// ResponseHeaders (optional) Response headers if intercepted at the response stage or if redirect occurred while
	// intercepting request or auth retry occurred.
	ResponseHeaders NetworkHeaders `json:"responseHeaders,omitempty"`

	// RequestID (optional) If the intercepted request had a corresponding requestWillBeSent event fired for it, then
	// this requestId will be the same as the requestId present in the requestWillBeSent event.
	RequestID NetworkRequestID `json:"requestId,omitempty"`
}

// ProtoEvent name.
func (evt NetworkRequestIntercepted) ProtoEvent() string {
	return "Network.requestIntercepted"
}

// NetworkRequestServedFromCache Fired if request ended up loading from cache.
type NetworkRequestServedFromCache struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`
}

// ProtoEvent name.
func (evt NetworkRequestServedFromCache) ProtoEvent() string {
	return "Network.requestServedFromCache"
}

// NetworkRequestWillBeSent Fired when page is about to send HTTP request.
type NetworkRequestWillBeSent struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// LoaderID Loader identifier. Empty string if the request is fetched from worker.
	LoaderID NetworkLoaderID `json:"loaderId"`

	// DocumentURL URL of the document this request is loaded for.
	DocumentURL string `json:"documentURL"`

	// Request data.
	Request *NetworkRequest `json:"request"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// WallTime Timestamp.
	WallTime TimeSinceEpoch `json:"wallTime"`

	// Initiator Request initiator.
	Initiator *NetworkInitiator `json:"initiator"`

	// RedirectHasExtraInfo (experimental) In the case that redirectResponse is populated, this flag indicates whether
	// requestWillBeSentExtraInfo and responseReceivedExtraInfo events will be or were emitted
	// for the request which was just redirected.
	RedirectHasExtraInfo bool `json:"redirectHasExtraInfo"`

	// RedirectResponse (optional) Redirect response data.
	RedirectResponse *NetworkResponse `json:"redirectResponse,omitempty"`

	// Type (optional) Type of this resource.
	Type NetworkResourceType `json:"type,omitempty"`

	// FrameID (optional) Frame identifier.
	FrameID PageFrameID `json:"frameId,omitempty"`

	// HasUserGesture (optional) Whether the request is initiated by a user gesture. Defaults to false.
	HasUserGesture bool `json:"hasUserGesture,omitempty"`
}

// ProtoEvent name.
func (evt NetworkRequestWillBeSent) ProtoEvent() string {
	return "Network.requestWillBeSent"
}

// NetworkResourceChangedPriority (experimental) Fired when resource loading priority is changed.
type NetworkResourceChangedPriority struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// NewPriority New priority
	NewPriority NetworkResourcePriority `json:"newPriority"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`
}

// ProtoEvent name.
func (evt NetworkResourceChangedPriority) ProtoEvent() string {
	return "Network.resourceChangedPriority"
}

// NetworkSignedExchangeReceived (experimental) Fired when a signed exchange was received over the network.
type NetworkSignedExchangeReceived struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Information about the signed exchange response.
	Info *NetworkSignedExchangeInfo `json:"info"`
}

// ProtoEvent name.
func (evt NetworkSignedExchangeReceived) ProtoEvent() string {
	return "Network.signedExchangeReceived"
}

// NetworkResponseReceived Fired when HTTP response is available.
type NetworkResponseReceived struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// LoaderID Loader identifier. Empty string if the request is fetched from worker.
	LoaderID NetworkLoaderID `json:"loaderId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// Type Resource type.
	Type NetworkResourceType `json:"type"`

	// Response data.
	Response *NetworkResponse `json:"response"`

	// HasExtraInfo (experimental) Indicates whether requestWillBeSentExtraInfo and responseReceivedExtraInfo events will be
	// or were emitted for this request.
	HasExtraInfo bool `json:"hasExtraInfo"`

	// FrameID (optional) Frame identifier.
	FrameID PageFrameID `json:"frameId,omitempty"`
}

// ProtoEvent name.
func (evt NetworkResponseReceived) ProtoEvent() string {
	return "Network.responseReceived"
}

// NetworkWebSocketClosed Fired when WebSocket is closed.
type NetworkWebSocketClosed struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`
}

// ProtoEvent name.
func (evt NetworkWebSocketClosed) ProtoEvent() string {
	return "Network.webSocketClosed"
}

// NetworkWebSocketCreated Fired upon WebSocket creation.
type NetworkWebSocketCreated struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// URL WebSocket request URL.
	URL string `json:"url"`

	// Initiator (optional) Request initiator.
	Initiator *NetworkInitiator `json:"initiator,omitempty"`
}

// ProtoEvent name.
func (evt NetworkWebSocketCreated) ProtoEvent() string {
	return "Network.webSocketCreated"
}

// NetworkWebSocketFrameError Fired when WebSocket message error occurs.
type NetworkWebSocketFrameError struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// ErrorMessage WebSocket error message.
	ErrorMessage string `json:"errorMessage"`
}

// ProtoEvent name.
func (evt NetworkWebSocketFrameError) ProtoEvent() string {
	return "Network.webSocketFrameError"
}

// NetworkWebSocketFrameReceived Fired when WebSocket message is received.
type NetworkWebSocketFrameReceived struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// Response WebSocket response data.
	Response *NetworkWebSocketFrame `json:"response"`
}

// ProtoEvent name.
func (evt NetworkWebSocketFrameReceived) ProtoEvent() string {
	return "Network.webSocketFrameReceived"
}

// NetworkWebSocketFrameSent Fired when WebSocket message is sent.
type NetworkWebSocketFrameSent struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// Response WebSocket response data.
	Response *NetworkWebSocketFrame `json:"response"`
}

// ProtoEvent name.
func (evt NetworkWebSocketFrameSent) ProtoEvent() string {
	return "Network.webSocketFrameSent"
}

// NetworkWebSocketHandshakeResponseReceived Fired when WebSocket handshake response becomes available.
type NetworkWebSocketHandshakeResponseReceived struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// Response WebSocket response data.
	Response *NetworkWebSocketResponse `json:"response"`
}

// ProtoEvent name.
func (evt NetworkWebSocketHandshakeResponseReceived) ProtoEvent() string {
	return "Network.webSocketHandshakeResponseReceived"
}

// NetworkWebSocketWillSendHandshakeRequest Fired when WebSocket is about to initiate handshake.
type NetworkWebSocketWillSendHandshakeRequest struct {
	// RequestID Request identifier.
	RequestID NetworkRequestID `json:"requestId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// WallTime UTC Timestamp.
	WallTime TimeSinceEpoch `json:"wallTime"`

	// Request WebSocket request data.
	Request *NetworkWebSocketRequest `json:"request"`
}

// ProtoEvent name.
func (evt NetworkWebSocketWillSendHandshakeRequest) ProtoEvent() string {
	return "Network.webSocketWillSendHandshakeRequest"
}

// NetworkWebTransportCreated Fired upon WebTransport creation.
type NetworkWebTransportCreated struct {
	// TransportID WebTransport identifier.
	TransportID NetworkRequestID `json:"transportId"`

	// URL WebTransport request URL.
	URL string `json:"url"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`

	// Initiator (optional) Request initiator.
	Initiator *NetworkInitiator `json:"initiator,omitempty"`
}

// ProtoEvent name.
func (evt NetworkWebTransportCreated) ProtoEvent() string {
	return "Network.webTransportCreated"
}

// NetworkWebTransportConnectionEstablished Fired when WebTransport handshake is finished.
type NetworkWebTransportConnectionEstablished struct {
	// TransportID WebTransport identifier.
	TransportID NetworkRequestID `json:"transportId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`
}

// ProtoEvent name.
func (evt NetworkWebTransportConnectionEstablished) ProtoEvent() string {
	return "Network.webTransportConnectionEstablished"
}

// NetworkWebTransportClosed Fired when WebTransport is disposed.
type NetworkWebTransportClosed struct {
	// TransportID WebTransport identifier.
	TransportID NetworkRequestID `json:"transportId"`

	// Timestamp.
	Timestamp MonotonicTime `json:"timestamp"`
}

// ProtoEvent name.
func (evt NetworkWebTransportClosed) ProtoEvent() string {
	return "Network.webTransportClosed"
}

// NetworkRequestWillBeSentExtraInfo (experimental) Fired when additional information about a requestWillBeSent event is available from the
// network stack. Not every requestWillBeSent event will have an additional
// requestWillBeSentExtraInfo fired for it, and there is no guarantee whether requestWillBeSent
// or requestWillBeSentExtraInfo will be fired first for the same request.
type NetworkRequestWillBeSentExtraInfo struct {
	// RequestID Request identifier. Used to match this information to an existing requestWillBeSent event.
	RequestID NetworkRequestID `json:"requestId"`

	// AssociatedCookies A list of cookies potentially associated to the requested URL. This includes both cookies sent with
	// the request and the ones not sent; the latter are distinguished by having blockedReasons field set.
	AssociatedCookies []*NetworkAssociatedCookie `json:"associatedCookies"`

	// Headers Raw request headers as they will be sent over the wire.
	Headers NetworkHeaders `json:"headers"`

	// ConnectTiming (experimental) Connection timing information for the request.
	ConnectTiming *NetworkConnectTiming `json:"connectTiming"`

	// ClientSecurityState (optional) The client security state set for the request.
	ClientSecurityState *NetworkClientSecurityState `json:"clientSecurityState,omitempty"`

	// SiteHasCookieInOtherPartition (optional) Whether the site has partitioned cookies stored in a partition different than the current one.
	SiteHasCookieInOtherPartition bool `json:"siteHasCookieInOtherPartition,omitempty"`
}

// ProtoEvent name.
func (evt NetworkRequestWillBeSentExtraInfo) ProtoEvent() string {
	return "Network.requestWillBeSentExtraInfo"
}

// NetworkResponseReceivedExtraInfo (experimental) Fired when additional information about a responseReceived event is available from the network
// stack. Not every responseReceived event will have an additional responseReceivedExtraInfo for
// it, and responseReceivedExtraInfo may be fired before or after responseReceived.
type NetworkResponseReceivedExtraInfo struct {
	// RequestID Request identifier. Used to match this information to another responseReceived event.
	RequestID NetworkRequestID `json:"requestId"`

	// BlockedCookies A list of cookies which were not stored from the response along with the corresponding
	// reasons for blocking. The cookies here may not be valid due to syntax errors, which
	// are represented by the invalid cookie line string instead of a proper cookie.
	BlockedCookies []*NetworkBlockedSetCookieWithReason `json:"blockedCookies"`

	// Headers Raw response headers as they were received over the wire.
	Headers NetworkHeaders `json:"headers"`

	// ResourceIPAddressSpace The IP address space of the resource. The address space can only be determined once the transport
	// established the connection, so we can't send it in `requestWillBeSentExtraInfo`.
	ResourceIPAddressSpace NetworkIPAddressSpace `json:"resourceIPAddressSpace"`

	// StatusCode The status code of the response. This is useful in cases the request failed and no responseReceived
	// event is triggered, which is the case for, e.g., CORS errors. This is also the correct status code
	// for cached requests, where the status in responseReceived is a 200 and this will be 304.
	StatusCode int `json:"statusCode"`

	// HeadersText (optional) Raw response header text as it was received over the wire. The raw text may not always be
	// available, such as in the case of HTTP/2 or QUIC.
	HeadersText string `json:"headersText,omitempty"`

	// CookiePartitionKey (optional) The cookie partition key that will be used to store partitioned cookies set in this response.
	// Only sent when partitioned cookies are enabled.
	CookiePartitionKey string `json:"cookiePartitionKey,omitempty"`

	// CookiePartitionKeyOpaque (optional) True if partitioned cookies are enabled, but the partition key is not serializable to string.
	CookiePartitionKeyOpaque bool `json:"cookiePartitionKeyOpaque,omitempty"`

	// ExemptedCookies (optional) A list of cookies which should have been blocked by 3PCD but are exempted and stored from
	// the response with the corresponding reason.
	ExemptedCookies []*NetworkExemptedSetCookieWithReason `json:"exemptedCookies,omitempty"`
}

// ProtoEvent name.
func (evt NetworkResponseReceivedExtraInfo) ProtoEvent() string {
	return "Network.responseReceivedExtraInfo"
}

// NetworkResponseReceivedEarlyHints (experimental) Fired when 103 Early Hints headers is received in addition to the common response.
// Not every responseReceived event will have an responseReceivedEarlyHints fired.
// Only one responseReceivedEarlyHints may be fired for eached responseReceived event.
type NetworkResponseReceivedEarlyHints struct {
	// RequestID Request identifier. Used to match this information to another responseReceived event.
	RequestID NetworkRequestID `json:"requestId"`

	// Headers Raw response headers as they were received over the wire.
	Headers NetworkHeaders `json:"headers"`
}

// ProtoEvent name.
func (evt NetworkResponseReceivedEarlyHints) ProtoEvent() string {
	return "Network.responseReceivedEarlyHints"
}

// NetworkTrustTokenOperationDoneStatus enum.
type NetworkTrustTokenOperationDoneStatus string

const (
	// NetworkTrustTokenOperationDoneStatusOk enum const.
	NetworkTrustTokenOperationDoneStatusOk NetworkTrustTokenOperationDoneStatus = "Ok"

	// NetworkTrustTokenOperationDoneStatusInvalidArgument enum const.
	NetworkTrustTokenOperationDoneStatusInvalidArgument NetworkTrustTokenOperationDoneStatus = "InvalidArgument"

	// NetworkTrustTokenOperationDoneStatusMissingIssuerKeys enum const.
	NetworkTrustTokenOperationDoneStatusMissingIssuerKeys NetworkTrustTokenOperationDoneStatus = "MissingIssuerKeys"

	// NetworkTrustTokenOperationDoneStatusFailedPrecondition enum const.
	NetworkTrustTokenOperationDoneStatusFailedPrecondition NetworkTrustTokenOperationDoneStatus = "FailedPrecondition"

	// NetworkTrustTokenOperationDoneStatusResourceExhausted enum const.
	NetworkTrustTokenOperationDoneStatusResourceExhausted NetworkTrustTokenOperationDoneStatus = "ResourceExhausted"

	// NetworkTrustTokenOperationDoneStatusAlreadyExists enum const.
	NetworkTrustTokenOperationDoneStatusAlreadyExists NetworkTrustTokenOperationDoneStatus = "AlreadyExists"

	// NetworkTrustTokenOperationDoneStatusUnavailable enum const.
	NetworkTrustTokenOperationDoneStatusUnavailable NetworkTrustTokenOperationDoneStatus = "Unavailable"

	// NetworkTrustTokenOperationDoneStatusUnauthorized enum const.
	NetworkTrustTokenOperationDoneStatusUnauthorized NetworkTrustTokenOperationDoneStatus = "Unauthorized"

	// NetworkTrustTokenOperationDoneStatusBadResponse enum const.
	NetworkTrustTokenOperationDoneStatusBadResponse NetworkTrustTokenOperationDoneStatus = "BadResponse"

	// NetworkTrustTokenOperationDoneStatusInternalError enum const.
	NetworkTrustTokenOperationDoneStatusInternalError NetworkTrustTokenOperationDoneStatus = "InternalError"

	// NetworkTrustTokenOperationDoneStatusUnknownError enum const.
	NetworkTrustTokenOperationDoneStatusUnknownError NetworkTrustTokenOperationDoneStatus = "UnknownError"

	// NetworkTrustTokenOperationDoneStatusFulfilledLocally enum const.
	NetworkTrustTokenOperationDoneStatusFulfilledLocally NetworkTrustTokenOperationDoneStatus = "FulfilledLocally"
)

// NetworkTrustTokenOperationDone (experimental) Fired exactly once for each Trust Token operation. Depending on
// the type of the operation and whether the operation succeeded or
// failed, the event is fired before the corresponding request was sent
// or after the response was received.
type NetworkTrustTokenOperationDone struct {
	// Status Detailed success or error status of the operation.
	// 'AlreadyExists' also signifies a successful operation, as the result
	// of the operation already exists und thus, the operation was abort
	// preemptively (e.g. a cache hit).
	Status NetworkTrustTokenOperationDoneStatus `json:"status"`

	// Type ...
	Type NetworkTrustTokenOperationType `json:"type"`

	// RequestID ...
	RequestID NetworkRequestID `json:"requestId"`

	// TopLevelOrigin (optional) Top level origin. The context in which the operation was attempted.
	TopLevelOrigin string `json:"topLevelOrigin,omitempty"`

	// IssuerOrigin (optional) Origin of the issuer in case of a "Issuance" or "Redemption" operation.
	IssuerOrigin string `json:"issuerOrigin,omitempty"`

	// IssuedTokenCount (optional) The number of obtained Trust Tokens on a successful "Issuance" operation.
	IssuedTokenCount *int `json:"issuedTokenCount,omitempty"`
}

// ProtoEvent name.
func (evt NetworkTrustTokenOperationDone) ProtoEvent() string {
	return "Network.trustTokenOperationDone"
}

// NetworkSubresourceWebBundleMetadataReceived (experimental) Fired once when parsing the .wbn file has succeeded.
// The event contains the information about the web bundle contents.
type NetworkSubresourceWebBundleMetadataReceived struct {
	// RequestID Request identifier. Used to match this information to another event.
	RequestID NetworkRequestID `json:"requestId"`

	// Urls A list of URLs of resources in the subresource Web Bundle.
	Urls []string `json:"urls"`
}

// ProtoEvent name.
func (evt NetworkSubresourceWebBundleMetadataReceived) ProtoEvent() string {
	return "Network.subresourceWebBundleMetadataReceived"
}

// NetworkSubresourceWebBundleMetadataError (experimental) Fired once when parsing the .wbn file has failed.
type NetworkSubresourceWebBundleMetadataError struct {
	// RequestID Request identifier. Used to match this information to another event.
	RequestID NetworkRequestID `json:"requestId"`

	// ErrorMessage Error message
	ErrorMessage string `json:"errorMessage"`
}

// ProtoEvent name.
func (evt NetworkSubresourceWebBundleMetadataError) ProtoEvent() string {
	return "Network.subresourceWebBundleMetadataError"
}

// NetworkSubresourceWebBundleInnerResponseParsed (experimental) Fired when handling requests for resources within a .wbn file.
// Note: this will only be fired for resources that are requested by the webpage.
type NetworkSubresourceWebBundleInnerResponseParsed struct {
	// InnerRequestID Request identifier of the subresource request
	InnerRequestID NetworkRequestID `json:"innerRequestId"`

	// InnerRequestURL URL of the subresource resource.
	InnerRequestURL string `json:"innerRequestURL"`

	// BundleRequestID (optional) Bundle request identifier. Used to match this information to another event.
	// This made be absent in case when the instrumentation was enabled only
	// after webbundle was parsed.
	BundleRequestID NetworkRequestID `json:"bundleRequestId,omitempty"`
}

// ProtoEvent name.
func (evt NetworkSubresourceWebBundleInnerResponseParsed) ProtoEvent() string {
	return "Network.subresourceWebBundleInnerResponseParsed"
}

// NetworkSubresourceWebBundleInnerResponseError (experimental) Fired when request for resources within a .wbn file failed.
type NetworkSubresourceWebBundleInnerResponseError struct {
	// InnerRequestID Request identifier of the subresource request
	InnerRequestID NetworkRequestID `json:"innerRequestId"`

	// InnerRequestURL URL of the subresource resource.
	InnerRequestURL string `json:"innerRequestURL"`

	// ErrorMessage Error message
	ErrorMessage string `json:"errorMessage"`

	// BundleRequestID (optional) Bundle request identifier. Used to match this information to another event.
	// This made be absent in case when the instrumentation was enabled only
	// after webbundle was parsed.
	BundleRequestID NetworkRequestID `json:"bundleRequestId,omitempty"`
}

// ProtoEvent name.
func (evt NetworkSubresourceWebBundleInnerResponseError) ProtoEvent() string {
	return "Network.subresourceWebBundleInnerResponseError"
}

// NetworkReportingAPIReportAdded (experimental) Is sent whenever a new report is added.
// And after 'enableReportingApi' for all existing reports.
type NetworkReportingAPIReportAdded struct {
	// Report ...
	Report *NetworkReportingAPIReport `json:"report"`
}

// ProtoEvent name.
func (evt NetworkReportingAPIReportAdded) ProtoEvent() string {
	return "Network.reportingApiReportAdded"
}

// NetworkReportingAPIReportUpdated (experimental) ...
type NetworkReportingAPIReportUpdated struct {
	// Report ...
	Report *NetworkReportingAPIReport `json:"report"`
}

// ProtoEvent name.
func (evt NetworkReportingAPIReportUpdated) ProtoEvent() string {
	return "Network.reportingApiReportUpdated"
}

// NetworkReportingAPIEndpointsChangedForOrigin (experimental) ...
type NetworkReportingAPIEndpointsChangedForOrigin struct {
	// Origin of the document(s) which configured the endpoints.
	Origin string `json:"origin"`

	// Endpoints ...
	Endpoints []*NetworkReportingAPIEndpoint `json:"endpoints"`
}

// ProtoEvent name.
func (evt NetworkReportingAPIEndpointsChangedForOrigin) ProtoEvent() string {
	return "Network.reportingApiEndpointsChangedForOrigin"
}
