// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new packer service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for packer service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	PackerServiceCreateBucket(params *PackerServiceCreateBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateBucketOK, error)

	PackerServiceCreateBuild(params *PackerServiceCreateBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateBuildOK, error)

	PackerServiceCreateChannel(params *PackerServiceCreateChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateChannelOK, error)

	PackerServiceCreateIteration(params *PackerServiceCreateIterationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateIterationOK, error)

	PackerServiceCreateRegistry(params *PackerServiceCreateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateRegistryOK, error)

	PackerServiceDeleteBucket(params *PackerServiceDeleteBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteBucketOK, error)

	PackerServiceDeleteBuild(params *PackerServiceDeleteBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteBuildOK, error)

	PackerServiceDeleteChannel(params *PackerServiceDeleteChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteChannelOK, error)

	PackerServiceDeleteIteration(params *PackerServiceDeleteIterationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteIterationOK, error)

	PackerServiceDeleteRegistry(params *PackerServiceDeleteRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteRegistryOK, error)

	PackerServiceGetBucket(params *PackerServiceGetBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetBucketOK, error)

	PackerServiceGetBuild(params *PackerServiceGetBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetBuildOK, error)

	PackerServiceGetChannel(params *PackerServiceGetChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetChannelOK, error)

	PackerServiceGetIteration(params *PackerServiceGetIterationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetIterationOK, error)

	PackerServiceGetRegistry(params *PackerServiceGetRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetRegistryOK, error)

	PackerServiceGetRegistryTFCRunTaskAPI(params *PackerServiceGetRegistryTFCRunTaskAPIParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetRegistryTFCRunTaskAPIOK, error)

	PackerServiceListBucketAncestry(params *PackerServiceListBucketAncestryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBucketAncestryOK, error)

	PackerServiceListBuckets(params *PackerServiceListBucketsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBucketsOK, error)

	PackerServiceListBuilds(params *PackerServiceListBuildsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBuildsOK, error)

	PackerServiceListChannels(params *PackerServiceListChannelsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListChannelsOK, error)

	PackerServiceListIterations(params *PackerServiceListIterationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListIterationsOK, error)

	PackerServiceRegenerateTFCRunTaskHmacKey(params *PackerServiceRegenerateTFCRunTaskHmacKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceRegenerateTFCRunTaskHmacKeyOK, error)

	PackerServiceTFCImageValidationRunTask(params *PackerServiceTFCImageValidationRunTaskParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceTFCImageValidationRunTaskOK, error)

	PackerServiceUpdateBucket(params *PackerServiceUpdateBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateBucketOK, error)

	PackerServiceUpdateBuild(params *PackerServiceUpdateBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateBuildOK, error)

	PackerServiceUpdateChannel(params *PackerServiceUpdateChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateChannelOK, error)

	PackerServiceUpdateIteration(params *PackerServiceUpdateIterationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateIterationOK, error)

	PackerServiceUpdateRegistry(params *PackerServiceUpdateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateRegistryOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
PackerServiceCreateBucket creates an image bucket in the h c p packer registry
*/
func (a *Client) PackerServiceCreateBucket(params *PackerServiceCreateBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateBucketOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceCreateBucketParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_CreateBucket",
		Method:             "PUT",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceCreateBucketReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceCreateBucketOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceCreateBucketDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceCreateBuild creates an image build in the provided image iteration it is called once for each build source in a packer build run the request will error if the build for a given cloud provider already exists
*/
func (a *Client) PackerServiceCreateBuild(params *PackerServiceCreateBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateBuildOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceCreateBuildParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_CreateBuild",
		Method:             "POST",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/iterations/{iteration_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceCreateBuildReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceCreateBuildOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceCreateBuildDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceCreateChannel creates a channel either empty or assigned to an iteration
*/
func (a *Client) PackerServiceCreateChannel(params *PackerServiceCreateChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateChannelOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceCreateChannelParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_CreateChannel",
		Method:             "POST",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceCreateChannelReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceCreateChannelOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceCreateChannelDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceCreateIteration creates an empty iteration to be written to this API is called at the beginning of a new packer build and does not create individual builds for the iteration
*/
func (a *Client) PackerServiceCreateIteration(params *PackerServiceCreateIterationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateIterationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceCreateIterationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_CreateIteration",
		Method:             "POST",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/iterations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceCreateIterationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceCreateIterationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceCreateIterationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceCreateRegistry creates a h c p packer registry and starts billing for it
*/
func (a *Client) PackerServiceCreateRegistry(params *PackerServiceCreateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceCreateRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_CreateRegistry",
		Method:             "PUT",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/registry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceCreateRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceCreateRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceCreateRegistryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceDeleteBucket deletes a bucket and all its information such as iterations and builds
*/
func (a *Client) PackerServiceDeleteBucket(params *PackerServiceDeleteBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteBucketOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceDeleteBucketParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_DeleteBucket",
		Method:             "DELETE",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceDeleteBucketReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceDeleteBucketOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceDeleteBucketDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceDeleteBuild deletes a build in the provided iteration
*/
func (a *Client) PackerServiceDeleteBuild(params *PackerServiceDeleteBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteBuildOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceDeleteBuildParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_DeleteBuild",
		Method:             "DELETE",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/builds/{build_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceDeleteBuildReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceDeleteBuildOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceDeleteBuildDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceDeleteChannel deletes a channel
*/
func (a *Client) PackerServiceDeleteChannel(params *PackerServiceDeleteChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteChannelOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceDeleteChannelParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_DeleteChannel",
		Method:             "DELETE",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceDeleteChannelReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceDeleteChannelOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceDeleteChannelDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceDeleteIteration deletes an iteration and all its information such as its builds
*/
func (a *Client) PackerServiceDeleteIteration(params *PackerServiceDeleteIterationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteIterationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceDeleteIterationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_DeleteIteration",
		Method:             "DELETE",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/iterations/{iteration_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceDeleteIterationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceDeleteIterationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceDeleteIterationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceDeleteRegistry deactivates an active h c p packer registry deactivating a registry will stop any additional billing for the resource setting the hard delete param to true will delete the registry and any associated resources from the database
*/
func (a *Client) PackerServiceDeleteRegistry(params *PackerServiceDeleteRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceDeleteRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_DeleteRegistry",
		Method:             "DELETE",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/registry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceDeleteRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceDeleteRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceDeleteRegistryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetBucket gets a bucket with its latest completed iteration
*/
func (a *Client) PackerServiceGetBucket(params *PackerServiceGetBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetBucketOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetBucketParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetBucket",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetBucketReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetBucketOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetBucketDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetBuild gets a build with its list of images
*/
func (a *Client) PackerServiceGetBuild(params *PackerServiceGetBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetBuildOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetBuildParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetBuild",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/builds/{build_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetBuildReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetBuildOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetBuildDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetChannel gets a channel with the iteration that it is currently assigned if any
*/
func (a *Client) PackerServiceGetChannel(params *PackerServiceGetChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetChannelOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetChannelParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetChannel",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetChannelReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetChannelOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetChannelDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetIteration allows the user to get an iteration using one of the following identifiers iteration id incremental version fingerprint these are supplied as a query parameter e g images bucket slug iteration fingerprint fingerprint
*/
func (a *Client) PackerServiceGetIteration(params *PackerServiceGetIterationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetIterationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetIterationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetIteration",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/iteration",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetIterationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetIterationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetIterationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetRegistry gets a h c p packer registry
*/
func (a *Client) PackerServiceGetRegistry(params *PackerServiceGetRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetRegistry",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/registry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetRegistryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetRegistryTFCRunTaskAPI gets the h c p packer registry API URL and h m a c key to integrate with terraform cloud as a run task
*/
func (a *Client) PackerServiceGetRegistryTFCRunTaskAPI(params *PackerServiceGetRegistryTFCRunTaskAPIParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetRegistryTFCRunTaskAPIOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetRegistryTFCRunTaskAPIParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetRegistryTFCRunTaskAPI",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/runtasks/{task_type}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetRegistryTFCRunTaskAPIReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetRegistryTFCRunTaskAPIOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetRegistryTFCRunTaskAPIDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListBucketAncestry lists the ancestry relationships for an image bucket this includes direct source images parents and downstream images built directly from the image bucket children
*/
func (a *Client) PackerServiceListBucketAncestry(params *PackerServiceListBucketAncestryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBucketAncestryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListBucketAncestryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListBucketAncestry",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/ancestry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListBucketAncestryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListBucketAncestryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListBucketAncestryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListBuckets lists every existing bucket in the h c p packer registry and their last completed iteration
*/
func (a *Client) PackerServiceListBuckets(params *PackerServiceListBucketsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBucketsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListBucketsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListBuckets",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListBucketsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListBucketsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListBucketsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListBuilds lists every existing build and its images for an iteration
*/
func (a *Client) PackerServiceListBuilds(params *PackerServiceListBuildsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBuildsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListBuildsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListBuilds",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/iterations/{iteration_id}/builds",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListBuildsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListBuildsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListBuildsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListChannels lists all channels of a given bucket
*/
func (a *Client) PackerServiceListChannels(params *PackerServiceListChannelsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListChannelsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListChannelsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListChannels",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListChannelsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListChannelsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListChannelsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListIterations lists every existing iteration of a bucket
*/
func (a *Client) PackerServiceListIterations(params *PackerServiceListIterationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListIterationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListIterationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListIterations",
		Method:             "GET",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/iterations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListIterationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListIterationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListIterationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceRegenerateTFCRunTaskHmacKey regenerates the h m a c key used to sign requests from terraform cloud to h c p packer run tasks
*/
func (a *Client) PackerServiceRegenerateTFCRunTaskHmacKey(params *PackerServiceRegenerateTFCRunTaskHmacKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceRegenerateTFCRunTaskHmacKeyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceRegenerateTFCRunTaskHmacKeyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_RegenerateTFCRunTaskHmacKey",
		Method:             "PATCH",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/runtasks/hmac",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceRegenerateTFCRunTaskHmacKeyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceRegenerateTFCRunTaskHmacKeyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceRegenerateTFCRunTaskHmacKeyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceTFCImageValidationRunTask terraforms cloud run task hook for validating an h c p packer artifact used in the terraform plan to block a terraform apply for artifacts that are in an invalid state such as revoked iterations
*/
func (a *Client) PackerServiceTFCImageValidationRunTask(params *PackerServiceTFCImageValidationRunTaskParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceTFCImageValidationRunTaskOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceTFCImageValidationRunTaskParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_TFCImageValidationRunTask",
		Method:             "POST",
		PathPattern:        "/packer/2022-04-11/terraform-cloud/validation/{api_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceTFCImageValidationRunTaskReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceTFCImageValidationRunTaskOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceTFCImageValidationRunTaskDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUpdateBucket updates a bucket s information
*/
func (a *Client) PackerServiceUpdateBucket(params *PackerServiceUpdateBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateBucketOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUpdateBucketParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UpdateBucket",
		Method:             "PATCH",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUpdateBucketReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUpdateBucketOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUpdateBucketDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUpdateBuild updates an image build this may be most often used for modifying the status of a currently running build
*/
func (a *Client) PackerServiceUpdateBuild(params *PackerServiceUpdateBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateBuildOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUpdateBuildParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UpdateBuild",
		Method:             "PATCH",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/builds/{build_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUpdateBuildReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUpdateBuildOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUpdateBuildDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUpdateChannel updates a channel to clear or point to a new iteration
*/
func (a *Client) PackerServiceUpdateChannel(params *PackerServiceUpdateChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateChannelOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUpdateChannelParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UpdateChannel",
		Method:             "PATCH",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUpdateChannelReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUpdateChannelOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUpdateChannelDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUpdateIteration this API can be used to revoke restore or complete an iteration revoking can be done at any time to complete or incomplete iterations immediately or in the future depending on the passing timestamp when an iteration is revoked all its descendants will automatically get revoked unless skip descendants revocation is set descendants will get revoked asynchronously to the request revoked iterations cannot be updated unless restored to make build specific updates for builds within the iteration use the update build endpoint
*/
func (a *Client) PackerServiceUpdateIteration(params *PackerServiceUpdateIterationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateIterationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUpdateIterationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UpdateIteration",
		Method:             "PATCH",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/iterations/{iteration_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUpdateIterationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUpdateIterationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUpdateIterationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUpdateRegistry updates the feature tier of an h c p packer registry
*/
func (a *Client) PackerServiceUpdateRegistry(params *PackerServiceUpdateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUpdateRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UpdateRegistry",
		Method:             "PATCH",
		PathPattern:        "/packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/registry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUpdateRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUpdateRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUpdateRegistryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
