// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/preview/2022-04-11/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceUpdateChannelReader is a Reader for the PackerServiceUpdateChannel structure.
type PackerServiceUpdateChannelReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceUpdateChannelReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceUpdateChannelOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceUpdateChannelDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceUpdateChannelOK creates a PackerServiceUpdateChannelOK with default headers values
func NewPackerServiceUpdateChannelOK() *PackerServiceUpdateChannelOK {
	return &PackerServiceUpdateChannelOK{}
}

/*
PackerServiceUpdateChannelOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceUpdateChannelOK struct {
	Payload *models.HashicorpCloudPacker20220411UpdateChannelResponse
}

// IsSuccess returns true when this packer service update channel o k response has a 2xx status code
func (o *PackerServiceUpdateChannelOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service update channel o k response has a 3xx status code
func (o *PackerServiceUpdateChannelOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service update channel o k response has a 4xx status code
func (o *PackerServiceUpdateChannelOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service update channel o k response has a 5xx status code
func (o *PackerServiceUpdateChannelOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service update channel o k response a status code equal to that given
func (o *PackerServiceUpdateChannelOK) IsCode(code int) bool {
	return code == 200
}

func (o *PackerServiceUpdateChannelOK) Error() string {
	return fmt.Sprintf("[PATCH /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] packerServiceUpdateChannelOK  %+v", 200, o.Payload)
}

func (o *PackerServiceUpdateChannelOK) String() string {
	return fmt.Sprintf("[PATCH /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] packerServiceUpdateChannelOK  %+v", 200, o.Payload)
}

func (o *PackerServiceUpdateChannelOK) GetPayload() *models.HashicorpCloudPacker20220411UpdateChannelResponse {
	return o.Payload
}

func (o *PackerServiceUpdateChannelOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20220411UpdateChannelResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceUpdateChannelDefault creates a PackerServiceUpdateChannelDefault with default headers values
func NewPackerServiceUpdateChannelDefault(code int) *PackerServiceUpdateChannelDefault {
	return &PackerServiceUpdateChannelDefault{
		_statusCode: code,
	}
}

/*
PackerServiceUpdateChannelDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceUpdateChannelDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the packer service update channel default response
func (o *PackerServiceUpdateChannelDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this packer service update channel default response has a 2xx status code
func (o *PackerServiceUpdateChannelDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service update channel default response has a 3xx status code
func (o *PackerServiceUpdateChannelDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service update channel default response has a 4xx status code
func (o *PackerServiceUpdateChannelDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service update channel default response has a 5xx status code
func (o *PackerServiceUpdateChannelDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service update channel default response a status code equal to that given
func (o *PackerServiceUpdateChannelDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *PackerServiceUpdateChannelDefault) Error() string {
	return fmt.Sprintf("[PATCH /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] PackerService_UpdateChannel default  %+v", o._statusCode, o.Payload)
}

func (o *PackerServiceUpdateChannelDefault) String() string {
	return fmt.Sprintf("[PATCH /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] PackerService_UpdateChannel default  %+v", o._statusCode, o.Payload)
}

func (o *PackerServiceUpdateChannelDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *PackerServiceUpdateChannelDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
