// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/preview/2022-04-11/models"
)

// NewPackerServiceUpdateIterationParams creates a new PackerServiceUpdateIterationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceUpdateIterationParams() *PackerServiceUpdateIterationParams {
	return &PackerServiceUpdateIterationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceUpdateIterationParamsWithTimeout creates a new PackerServiceUpdateIterationParams object
// with the ability to set a timeout on a request.
func NewPackerServiceUpdateIterationParamsWithTimeout(timeout time.Duration) *PackerServiceUpdateIterationParams {
	return &PackerServiceUpdateIterationParams{
		timeout: timeout,
	}
}

// NewPackerServiceUpdateIterationParamsWithContext creates a new PackerServiceUpdateIterationParams object
// with the ability to set a context for a request.
func NewPackerServiceUpdateIterationParamsWithContext(ctx context.Context) *PackerServiceUpdateIterationParams {
	return &PackerServiceUpdateIterationParams{
		Context: ctx,
	}
}

// NewPackerServiceUpdateIterationParamsWithHTTPClient creates a new PackerServiceUpdateIterationParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceUpdateIterationParamsWithHTTPClient(client *http.Client) *PackerServiceUpdateIterationParams {
	return &PackerServiceUpdateIterationParams{
		HTTPClient: client,
	}
}

/*
PackerServiceUpdateIterationParams contains all the parameters to send to the API endpoint

	for the packer service update iteration operation.

	Typically these are written to a http.Request.
*/
type PackerServiceUpdateIterationParams struct {

	// Body.
	Body *models.HashicorpCloudPacker20220411UpdateIterationRequest

	/* IterationID.

	   ULID of the iteration.
	*/
	IterationID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service update iteration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceUpdateIterationParams) WithDefaults() *PackerServiceUpdateIterationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service update iteration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceUpdateIterationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) WithTimeout(timeout time.Duration) *PackerServiceUpdateIterationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) WithContext(ctx context.Context) *PackerServiceUpdateIterationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) WithHTTPClient(client *http.Client) *PackerServiceUpdateIterationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) WithBody(body *models.HashicorpCloudPacker20220411UpdateIterationRequest) *PackerServiceUpdateIterationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) SetBody(body *models.HashicorpCloudPacker20220411UpdateIterationRequest) {
	o.Body = body
}

// WithIterationID adds the iterationID to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) WithIterationID(iterationID string) *PackerServiceUpdateIterationParams {
	o.SetIterationID(iterationID)
	return o
}

// SetIterationID adds the iterationId to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) SetIterationID(iterationID string) {
	o.IterationID = iterationID
}

// WithLocationOrganizationID adds the locationOrganizationID to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) WithLocationOrganizationID(locationOrganizationID string) *PackerServiceUpdateIterationParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) WithLocationProjectID(locationProjectID string) *PackerServiceUpdateIterationParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the packer service update iteration params
func (o *PackerServiceUpdateIterationParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceUpdateIterationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param iteration_id
	if err := r.SetPathParam("iteration_id", o.IterationID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
