// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package dblm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListVulnerabilityResourcesRequest wrapper for the ListVulnerabilityResources operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/dblm/ListVulnerabilityResources.go.html to see an example of how to use ListVulnerabilityResourcesRequest.
type ListVulnerabilityResourcesRequest struct {

	// The required ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListVulnerabilityResourcesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.
	SortBy ListVulnerabilityResourcesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// A filter to return only resources their lifecycleState matches the given lifecycleState.
	LifecycleState DblmVulnerabilityLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// A filter to return only database that match the given release version.
	DatabaseRelease *string `mandatory:"false" contributesTo:"query" name:"databaseRelease"`

	// The id of a CVE.
	CveId *string `mandatory:"false" contributesTo:"query" name:"cveId"`

	// Filter by one or more severity types.
	// Possible values are critical, high, medium, low, info and none.
	SeverityType []ResourcesSeveritiesEnum `contributesTo:"query" name:"severityType" omitEmpty:"true" collectionFormat:"multi"`

	// Filter by one or more severity types.
	// Possible values are upToDate, patchAvailable
	PatchRecommendation []ListVulnerabilityResourcesPatchRecommendationEnum `contributesTo:"query" name:"patchRecommendation" omitEmpty:"true" collectionFormat:"multi"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListVulnerabilityResourcesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListVulnerabilityResourcesRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListVulnerabilityResourcesRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListVulnerabilityResourcesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListVulnerabilityResourcesRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListVulnerabilityResourcesSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListVulnerabilityResourcesSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListVulnerabilityResourcesSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListVulnerabilityResourcesSortByEnumStringValues(), ",")))
	}
	if _, ok := GetMappingDblmVulnerabilityLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetDblmVulnerabilityLifecycleStateEnumStringValues(), ",")))
	}
	for _, val := range request.SeverityType {
		if _, ok := GetMappingResourcesSeveritiesEnum(string(val)); !ok && val != "" {
			errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SeverityType: %s. Supported values are: %s.", val, strings.Join(GetResourcesSeveritiesEnumStringValues(), ",")))
		}
	}

	for _, val := range request.PatchRecommendation {
		if _, ok := GetMappingListVulnerabilityResourcesPatchRecommendationEnum(string(val)); !ok && val != "" {
			errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for PatchRecommendation: %s. Supported values are: %s.", val, strings.Join(GetListVulnerabilityResourcesPatchRecommendationEnumStringValues(), ",")))
		}
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListVulnerabilityResourcesResponse wrapper for the ListVulnerabilityResources operation
type ListVulnerabilityResourcesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of VulnerabilityResourceCollection instances
	VulnerabilityResourceCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListVulnerabilityResourcesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListVulnerabilityResourcesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListVulnerabilityResourcesSortOrderEnum Enum with underlying type: string
type ListVulnerabilityResourcesSortOrderEnum string

// Set of constants representing the allowable values for ListVulnerabilityResourcesSortOrderEnum
const (
	ListVulnerabilityResourcesSortOrderAsc  ListVulnerabilityResourcesSortOrderEnum = "ASC"
	ListVulnerabilityResourcesSortOrderDesc ListVulnerabilityResourcesSortOrderEnum = "DESC"
)

var mappingListVulnerabilityResourcesSortOrderEnum = map[string]ListVulnerabilityResourcesSortOrderEnum{
	"ASC":  ListVulnerabilityResourcesSortOrderAsc,
	"DESC": ListVulnerabilityResourcesSortOrderDesc,
}

var mappingListVulnerabilityResourcesSortOrderEnumLowerCase = map[string]ListVulnerabilityResourcesSortOrderEnum{
	"asc":  ListVulnerabilityResourcesSortOrderAsc,
	"desc": ListVulnerabilityResourcesSortOrderDesc,
}

// GetListVulnerabilityResourcesSortOrderEnumValues Enumerates the set of values for ListVulnerabilityResourcesSortOrderEnum
func GetListVulnerabilityResourcesSortOrderEnumValues() []ListVulnerabilityResourcesSortOrderEnum {
	values := make([]ListVulnerabilityResourcesSortOrderEnum, 0)
	for _, v := range mappingListVulnerabilityResourcesSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityResourcesSortOrderEnumStringValues Enumerates the set of values in String for ListVulnerabilityResourcesSortOrderEnum
func GetListVulnerabilityResourcesSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListVulnerabilityResourcesSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityResourcesSortOrderEnum(val string) (ListVulnerabilityResourcesSortOrderEnum, bool) {
	enum, ok := mappingListVulnerabilityResourcesSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilityResourcesSortByEnum Enum with underlying type: string
type ListVulnerabilityResourcesSortByEnum string

// Set of constants representing the allowable values for ListVulnerabilityResourcesSortByEnum
const (
	ListVulnerabilityResourcesSortByTimecreated        ListVulnerabilityResourcesSortByEnum = "timeCreated"
	ListVulnerabilityResourcesSortByDisplayname        ListVulnerabilityResourcesSortByEnum = "displayName"
	ListVulnerabilityResourcesSortByVulnerabilitycount ListVulnerabilityResourcesSortByEnum = "vulnerabilityCount"
)

var mappingListVulnerabilityResourcesSortByEnum = map[string]ListVulnerabilityResourcesSortByEnum{
	"timeCreated":        ListVulnerabilityResourcesSortByTimecreated,
	"displayName":        ListVulnerabilityResourcesSortByDisplayname,
	"vulnerabilityCount": ListVulnerabilityResourcesSortByVulnerabilitycount,
}

var mappingListVulnerabilityResourcesSortByEnumLowerCase = map[string]ListVulnerabilityResourcesSortByEnum{
	"timecreated":        ListVulnerabilityResourcesSortByTimecreated,
	"displayname":        ListVulnerabilityResourcesSortByDisplayname,
	"vulnerabilitycount": ListVulnerabilityResourcesSortByVulnerabilitycount,
}

// GetListVulnerabilityResourcesSortByEnumValues Enumerates the set of values for ListVulnerabilityResourcesSortByEnum
func GetListVulnerabilityResourcesSortByEnumValues() []ListVulnerabilityResourcesSortByEnum {
	values := make([]ListVulnerabilityResourcesSortByEnum, 0)
	for _, v := range mappingListVulnerabilityResourcesSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityResourcesSortByEnumStringValues Enumerates the set of values in String for ListVulnerabilityResourcesSortByEnum
func GetListVulnerabilityResourcesSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"displayName",
		"vulnerabilityCount",
	}
}

// GetMappingListVulnerabilityResourcesSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityResourcesSortByEnum(val string) (ListVulnerabilityResourcesSortByEnum, bool) {
	enum, ok := mappingListVulnerabilityResourcesSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilityResourcesPatchRecommendationEnum Enum with underlying type: string
type ListVulnerabilityResourcesPatchRecommendationEnum string

// Set of constants representing the allowable values for ListVulnerabilityResourcesPatchRecommendationEnum
const (
	ListVulnerabilityResourcesPatchRecommendationUptodate       ListVulnerabilityResourcesPatchRecommendationEnum = "upToDate"
	ListVulnerabilityResourcesPatchRecommendationPatchavailable ListVulnerabilityResourcesPatchRecommendationEnum = "patchAvailable"
)

var mappingListVulnerabilityResourcesPatchRecommendationEnum = map[string]ListVulnerabilityResourcesPatchRecommendationEnum{
	"upToDate":       ListVulnerabilityResourcesPatchRecommendationUptodate,
	"patchAvailable": ListVulnerabilityResourcesPatchRecommendationPatchavailable,
}

var mappingListVulnerabilityResourcesPatchRecommendationEnumLowerCase = map[string]ListVulnerabilityResourcesPatchRecommendationEnum{
	"uptodate":       ListVulnerabilityResourcesPatchRecommendationUptodate,
	"patchavailable": ListVulnerabilityResourcesPatchRecommendationPatchavailable,
}

// GetListVulnerabilityResourcesPatchRecommendationEnumValues Enumerates the set of values for ListVulnerabilityResourcesPatchRecommendationEnum
func GetListVulnerabilityResourcesPatchRecommendationEnumValues() []ListVulnerabilityResourcesPatchRecommendationEnum {
	values := make([]ListVulnerabilityResourcesPatchRecommendationEnum, 0)
	for _, v := range mappingListVulnerabilityResourcesPatchRecommendationEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityResourcesPatchRecommendationEnumStringValues Enumerates the set of values in String for ListVulnerabilityResourcesPatchRecommendationEnum
func GetListVulnerabilityResourcesPatchRecommendationEnumStringValues() []string {
	return []string{
		"upToDate",
		"patchAvailable",
	}
}

// GetMappingListVulnerabilityResourcesPatchRecommendationEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityResourcesPatchRecommendationEnum(val string) (ListVulnerabilityResourcesPatchRecommendationEnum, bool) {
	enum, ok := mappingListVulnerabilityResourcesPatchRecommendationEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
