// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Dblm API
//
// A description of the Dblm API
//

package dblm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// AggregatedVulnerabilitySummary Singular information of an aggregated vulnerability datapoint.
type AggregatedVulnerabilitySummary struct {

	// UTC timestamp when the scan completed.
	Timestamp *common.SDKTime `mandatory:"true" json:"timestamp"`

	// Unresolved vulnerabilities that were found by the scan.
	VulnerabilitiesCount *int `mandatory:"true" json:"vulnerabilitiesCount"`

	// Registered databases against which the scan ran.
	RegisteredResourcesCount *int `mandatory:"true" json:"registeredResourcesCount"`
}

func (m AggregatedVulnerabilitySummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m AggregatedVulnerabilitySummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
