// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Dblm API
//
// A description of the Dblm API
//

package dblm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// DblmVulnerability A Dblm Vulnerability is a description of a Dblm Vulnerability.
// To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
// an administrator. If you're an administrator who needs to write policies to give users access, see
// Getting Started with Policies (https://docs.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm).
type DblmVulnerability struct {

	// Compartment Identifier.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// Resources objects.
	Resources []ResourceInfo `mandatory:"false" json:"resources"`

	// A message describing the status of the feature's state.
	Message *string `mandatory:"false" json:"message"`

	// The time the the Vulnerability was enabled. An RFC3339 formatted datetime string.
	TimeEnabled *common.SDKTime `mandatory:"false" json:"timeEnabled"`

	// The current state of the feature.
	LifecycleState DblmVulnerabilityLifecycleStateEnum `mandatory:"false" json:"lifecycleState,omitempty"`

	// Summary of dblm registered and unregistered resources.
	ResourcesSummary *interface{} `mandatory:"false" json:"resourcesSummary"`

	// Summary of vulnerabilities found in registered resources grouped by severity.
	VulnerabilitiesSummary *interface{} `mandatory:"false" json:"vulnerabilitiesSummary"`

	// Summary of the patch recommendations for databases.
	PatchRecommendationsSummary *interface{} `mandatory:"false" json:"patchRecommendationsSummary"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// System tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m DblmVulnerability) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m DblmVulnerability) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingDblmVulnerabilityLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetDblmVulnerabilityLifecycleStateEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// DblmVulnerabilityLifecycleStateEnum Enum with underlying type: string
type DblmVulnerabilityLifecycleStateEnum string

// Set of constants representing the allowable values for DblmVulnerabilityLifecycleStateEnum
const (
	DblmVulnerabilityLifecycleStateCreating       DblmVulnerabilityLifecycleStateEnum = "CREATING"
	DblmVulnerabilityLifecycleStateActive         DblmVulnerabilityLifecycleStateEnum = "ACTIVE"
	DblmVulnerabilityLifecycleStateFailed         DblmVulnerabilityLifecycleStateEnum = "FAILED"
	DblmVulnerabilityLifecycleStateNeedsAttention DblmVulnerabilityLifecycleStateEnum = "NEEDS_ATTENTION"
	DblmVulnerabilityLifecycleStateDeleting       DblmVulnerabilityLifecycleStateEnum = "DELETING"
	DblmVulnerabilityLifecycleStateDeleted        DblmVulnerabilityLifecycleStateEnum = "DELETED"
)

var mappingDblmVulnerabilityLifecycleStateEnum = map[string]DblmVulnerabilityLifecycleStateEnum{
	"CREATING":        DblmVulnerabilityLifecycleStateCreating,
	"ACTIVE":          DblmVulnerabilityLifecycleStateActive,
	"FAILED":          DblmVulnerabilityLifecycleStateFailed,
	"NEEDS_ATTENTION": DblmVulnerabilityLifecycleStateNeedsAttention,
	"DELETING":        DblmVulnerabilityLifecycleStateDeleting,
	"DELETED":         DblmVulnerabilityLifecycleStateDeleted,
}

var mappingDblmVulnerabilityLifecycleStateEnumLowerCase = map[string]DblmVulnerabilityLifecycleStateEnum{
	"creating":        DblmVulnerabilityLifecycleStateCreating,
	"active":          DblmVulnerabilityLifecycleStateActive,
	"failed":          DblmVulnerabilityLifecycleStateFailed,
	"needs_attention": DblmVulnerabilityLifecycleStateNeedsAttention,
	"deleting":        DblmVulnerabilityLifecycleStateDeleting,
	"deleted":         DblmVulnerabilityLifecycleStateDeleted,
}

// GetDblmVulnerabilityLifecycleStateEnumValues Enumerates the set of values for DblmVulnerabilityLifecycleStateEnum
func GetDblmVulnerabilityLifecycleStateEnumValues() []DblmVulnerabilityLifecycleStateEnum {
	values := make([]DblmVulnerabilityLifecycleStateEnum, 0)
	for _, v := range mappingDblmVulnerabilityLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetDblmVulnerabilityLifecycleStateEnumStringValues Enumerates the set of values in String for DblmVulnerabilityLifecycleStateEnum
func GetDblmVulnerabilityLifecycleStateEnumStringValues() []string {
	return []string{
		"CREATING",
		"ACTIVE",
		"FAILED",
		"NEEDS_ATTENTION",
		"DELETING",
		"DELETED",
	}
}

// GetMappingDblmVulnerabilityLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingDblmVulnerabilityLifecycleStateEnum(val string) (DblmVulnerabilityLifecycleStateEnum, bool) {
	enum, ok := mappingDblmVulnerabilityLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
