// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Generative AI Service Inference API
//
// OCI Generative AI is a fully managed service that provides a set of state-of-the-art, customizable large language models (LLMs) that cover a wide range of use cases for text generation, summarization, and text embeddings.
// Use the Generative AI service inference API to access your custom model endpoints, or to try the out-of-the-box models to /EN/generative-ai-inference/latest/ChatResult/Chat, /EN/generative-ai-inference/latest/GenerateTextResult/GenerateText, /EN/generative-ai-inference/latest/SummarizeTextResult/SummarizeText, and /EN/generative-ai-inference/latest/EmbedTextResult/EmbedText.
// To use a Generative AI custom model for inference, you must first create an endpoint for that model. Use the /EN/generative-ai/latest/ to /EN/generative-ai/latest/Model/ by fine-tuning an out-of-the-box model, or a previous version of a custom model, using your own data. Fine-tune the custom model on a /EN/generative-ai/latest/DedicatedAiCluster/. Then, create a /EN/generative-ai/latest/DedicatedAiCluster/ with an Endpoint to host your custom model. For resource management in the Generative AI service, use the /EN/generative-ai/latest/.
// To learn more about the service, see the Generative AI documentation (https://docs.oracle.com/iaas/Content/generative-ai/home.htm).
//

package generativeaiinference

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// CohereChatResponse The response to the chat conversation.
type CohereChatResponse struct {

	// Contents of the response that the model generates.
	Text *string `mandatory:"true" json:"text"`

	// The list of previous messages between the user and the model. The chat history gives the model context for responding to the user's inputs.
	ChatHistory []CohereMessage `mandatory:"false" json:"chatHistory"`

	// Inline citations for the generated response.
	Citations []Citation `mandatory:"false" json:"citations"`

	// If set to true, a search for documents is required.
	IsSearchRequired *bool `mandatory:"false" json:"isSearchRequired"`

	// If there is an error during the streaming scenario, then the `errorMessage` parameter contains details for the error.
	ErrorMessage *string `mandatory:"false" json:"errorMessage"`

	// The generated search queries.
	SearchQueries []SearchQuery `mandatory:"false" json:"searchQueries"`

	// The documents that the model can refer to when generating a response. Each document is a JSON string that represents the field and values of the document.
	// Example:
	// '[
	//   {
	//     "id": "doc_0",
	//     "snippet": "Emperor penguins are the tallest.",
	//     "title": "Tall penguins"
	//   },
	//   {
	//     "id": "doc_1",
	//     "snippet": "Emperor penguins only live in Antarctica.",
	//     "title": "Penguin habitats"
	//   }
	// ]'
	Documents []interface{} `mandatory:"false" json:"documents"`

	// A list of tool calls generated by the model.
	ToolCalls []CohereToolCall `mandatory:"false" json:"toolCalls"`

	// The full prompt that was sent to the model if isEcho is true when request.
	Prompt *string `mandatory:"false" json:"prompt"`

	Usage *Usage `mandatory:"false" json:"usage"`

	// Why the generation stopped.
	FinishReason CohereChatResponseFinishReasonEnum `mandatory:"true" json:"finishReason"`
}

func (m CohereChatResponse) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m CohereChatResponse) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingCohereChatResponseFinishReasonEnum(string(m.FinishReason)); !ok && m.FinishReason != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for FinishReason: %s. Supported values are: %s.", m.FinishReason, strings.Join(GetCohereChatResponseFinishReasonEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// MarshalJSON marshals to json representation
func (m CohereChatResponse) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeCohereChatResponse CohereChatResponse
	s := struct {
		DiscriminatorParam string `json:"apiFormat"`
		MarshalTypeCohereChatResponse
	}{
		"COHERE",
		(MarshalTypeCohereChatResponse)(m),
	}

	return json.Marshal(&s)
}

// UnmarshalJSON unmarshals from json
func (m *CohereChatResponse) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		ChatHistory      []coheremessage                    `json:"chatHistory"`
		Citations        []Citation                         `json:"citations"`
		IsSearchRequired *bool                              `json:"isSearchRequired"`
		ErrorMessage     *string                            `json:"errorMessage"`
		SearchQueries    []SearchQuery                      `json:"searchQueries"`
		Documents        []interface{}                      `json:"documents"`
		ToolCalls        []CohereToolCall                   `json:"toolCalls"`
		Prompt           *string                            `json:"prompt"`
		Usage            *Usage                             `json:"usage"`
		Text             *string                            `json:"text"`
		FinishReason     CohereChatResponseFinishReasonEnum `json:"finishReason"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	m.ChatHistory = make([]CohereMessage, len(model.ChatHistory))
	for i, n := range model.ChatHistory {
		nn, e = n.UnmarshalPolymorphicJSON(n.JsonData)
		if e != nil {
			return e
		}
		if nn != nil {
			m.ChatHistory[i] = nn.(CohereMessage)
		} else {
			m.ChatHistory[i] = nil
		}
	}
	m.Citations = make([]Citation, len(model.Citations))
	copy(m.Citations, model.Citations)
	m.IsSearchRequired = model.IsSearchRequired

	m.ErrorMessage = model.ErrorMessage

	m.SearchQueries = make([]SearchQuery, len(model.SearchQueries))
	copy(m.SearchQueries, model.SearchQueries)
	m.Documents = make([]interface{}, len(model.Documents))
	copy(m.Documents, model.Documents)
	m.ToolCalls = make([]CohereToolCall, len(model.ToolCalls))
	copy(m.ToolCalls, model.ToolCalls)
	m.Prompt = model.Prompt

	m.Usage = model.Usage

	m.Text = model.Text

	m.FinishReason = model.FinishReason

	return
}

// CohereChatResponseFinishReasonEnum Enum with underlying type: string
type CohereChatResponseFinishReasonEnum string

// Set of constants representing the allowable values for CohereChatResponseFinishReasonEnum
const (
	CohereChatResponseFinishReasonComplete   CohereChatResponseFinishReasonEnum = "COMPLETE"
	CohereChatResponseFinishReasonErrorToxic CohereChatResponseFinishReasonEnum = "ERROR_TOXIC"
	CohereChatResponseFinishReasonErrorLimit CohereChatResponseFinishReasonEnum = "ERROR_LIMIT"
	CohereChatResponseFinishReasonError      CohereChatResponseFinishReasonEnum = "ERROR"
	CohereChatResponseFinishReasonUserCancel CohereChatResponseFinishReasonEnum = "USER_CANCEL"
	CohereChatResponseFinishReasonMaxTokens  CohereChatResponseFinishReasonEnum = "MAX_TOKENS"
)

var mappingCohereChatResponseFinishReasonEnum = map[string]CohereChatResponseFinishReasonEnum{
	"COMPLETE":    CohereChatResponseFinishReasonComplete,
	"ERROR_TOXIC": CohereChatResponseFinishReasonErrorToxic,
	"ERROR_LIMIT": CohereChatResponseFinishReasonErrorLimit,
	"ERROR":       CohereChatResponseFinishReasonError,
	"USER_CANCEL": CohereChatResponseFinishReasonUserCancel,
	"MAX_TOKENS":  CohereChatResponseFinishReasonMaxTokens,
}

var mappingCohereChatResponseFinishReasonEnumLowerCase = map[string]CohereChatResponseFinishReasonEnum{
	"complete":    CohereChatResponseFinishReasonComplete,
	"error_toxic": CohereChatResponseFinishReasonErrorToxic,
	"error_limit": CohereChatResponseFinishReasonErrorLimit,
	"error":       CohereChatResponseFinishReasonError,
	"user_cancel": CohereChatResponseFinishReasonUserCancel,
	"max_tokens":  CohereChatResponseFinishReasonMaxTokens,
}

// GetCohereChatResponseFinishReasonEnumValues Enumerates the set of values for CohereChatResponseFinishReasonEnum
func GetCohereChatResponseFinishReasonEnumValues() []CohereChatResponseFinishReasonEnum {
	values := make([]CohereChatResponseFinishReasonEnum, 0)
	for _, v := range mappingCohereChatResponseFinishReasonEnum {
		values = append(values, v)
	}
	return values
}

// GetCohereChatResponseFinishReasonEnumStringValues Enumerates the set of values in String for CohereChatResponseFinishReasonEnum
func GetCohereChatResponseFinishReasonEnumStringValues() []string {
	return []string{
		"COMPLETE",
		"ERROR_TOXIC",
		"ERROR_LIMIT",
		"ERROR",
		"USER_CANCEL",
		"MAX_TOKENS",
	}
}

// GetMappingCohereChatResponseFinishReasonEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingCohereChatResponseFinishReasonEnum(val string) (CohereChatResponseFinishReasonEnum, bool) {
	enum, ok := mappingCohereChatResponseFinishReasonEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
