// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// UpdateContainerScanRegistryDetails Registry information for a container scan target
type UpdateContainerScanRegistryDetails interface {

	// URL of the registry. Required for non-OCIR registry types (for OCIR registry types, it can be inferred from the tenancy). If null, will not be updated.
	GetUrl() *string
}

type updatecontainerscanregistrydetails struct {
	JsonData []byte
	Url      *string `mandatory:"false" json:"url"`
	Type     string  `json:"type"`
}

// UnmarshalJSON unmarshals json
func (m *updatecontainerscanregistrydetails) UnmarshalJSON(data []byte) error {
	m.JsonData = data
	type Unmarshalerupdatecontainerscanregistrydetails updatecontainerscanregistrydetails
	s := struct {
		Model Unmarshalerupdatecontainerscanregistrydetails
	}{}
	err := json.Unmarshal(data, &s.Model)
	if err != nil {
		return err
	}
	m.Url = s.Model.Url
	m.Type = s.Model.Type

	return err
}

// UnmarshalPolymorphicJSON unmarshals polymorphic json
func (m *updatecontainerscanregistrydetails) UnmarshalPolymorphicJSON(data []byte) (interface{}, error) {

	if data == nil || string(data) == "null" {
		return nil, nil
	}

	var err error
	switch m.Type {
	case "OCIR":
		mm := UpdateOcirContainerScanRegistryDetails{}
		err = json.Unmarshal(data, &mm)
		return mm, err
	default:
		common.Logf("Received unsupported enum value for UpdateContainerScanRegistryDetails: %s.", m.Type)
		return *m, nil
	}
}

// GetUrl returns Url
func (m updatecontainerscanregistrydetails) GetUrl() *string {
	return m.Url
}

func (m updatecontainerscanregistrydetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m updatecontainerscanregistrydetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
