/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.reconstructor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.classfile.visitor.ReplaceDupLoadVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveDupConstantsAttributes {
    public static void Reconstruct(List<Instruction> list) {
        int dupStoreIndex = 0;
        while (dupStoreIndex < list.size()) {
            if (list.get((int)dupStoreIndex).opcode == 264) {
                DupStore dupstore = (DupStore)list.get(dupStoreIndex);
                int opcode = dupstore.objectref.opcode;
                if (opcode == 16 || opcode == 17) {
                    Instruction i = dupstore.objectref;
                    int dupLoadIndex = dupStoreIndex + 1;
                    ReplaceDupLoadVisitor visitor = new ReplaceDupLoadVisitor(dupstore, i);
                    int length = list.size();
                    while (dupLoadIndex < length) {
                        visitor.visit(list.get(dupLoadIndex));
                        if (visitor.getParentFound() != null) break;
                        ++dupLoadIndex;
                    }
                    visitor.init(dupstore, i);
                    while (dupLoadIndex < length) {
                        visitor.visit(list.get(dupLoadIndex));
                        if (visitor.getParentFound() != null) break;
                        ++dupLoadIndex;
                    }
                    list.remove(dupStoreIndex--);
                }
            }
            ++dupStoreIndex;
        }
    }
}

