/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.AuthorizedKeysFileLoader;
import com.sshtools.common.automate.AuthorizedKeysFileSaver;
import com.sshtools.common.automate.AuthorizedKeysFormat;
import com.sshtools.common.automate.RemoteIdentificationException;
import com.sshtools.common.automate.RemoteIdentificationFactory;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AuthorizedKeys {
    private HashMap keys = new HashMap();

    public Map getAuthorizedKeys() {
        return this.keys;
    }

    public void addKey(String username, SshPublicKey key) {
        if (!this.containsKey(key)) {
            this.keys.put(key, username);
        }
    }

    public void removeKey(SshPublicKey key) {
        this.keys.remove(key);
    }

    public boolean containsKey(SshPublicKey key) {
        return this.keys.containsValue(key);
    }

    public static AuthorizedKeys parse(byte[] formatted, String serverId, String hostname, AuthorizedKeysFileLoader loader) throws RemoteIdentificationException, IOException, InvalidSshKeyException {
        AuthorizedKeysFormat format = RemoteIdentificationFactory.getInstance(serverId, hostname).getAuthorizedKeysFormat();
        if (format.requiresKeyFiles()) {
            return format.unformat(formatted, loader);
        }
        return format.unformat(formatted);
    }

    public static byte[] create(AuthorizedKeys keys, String serverId, String hostname, AuthorizedKeysFileSaver saver) throws RemoteIdentificationException, IOException, InvalidSshKeyException {
        AuthorizedKeysFormat format = RemoteIdentificationFactory.getInstance(serverId, hostname).getAuthorizedKeysFormat();
        if (format.requiresKeyFiles()) {
            return format.format(keys, saver);
        }
        return format.format(keys);
    }
}

