/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gCLINE.data.OperationInfo;
import edu.harvard.mgh.purcell.gCLINE.data.RunCommand;
import edu.harvard.mgh.purcell.gCLINE.general.GCFileChooser;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class OpenHapDialog
extends JDialog {
    private static Logger logger = Logger.getLogger(OpenHapDialog.class);
    private GPLINK frame;
    private static String[] pedSuffex = new String[]{".ped"};
    private static String[] infoSuffex = new String[]{".info"};
    private JRadioButton pedInfoRB = new JRadioButton("ped/info file set");
    private JTextField pedFile = new JTextField(20);
    private JButton pedButton = new JButton("Browse");
    private JTextField infoFile = new JTextField(20);
    private JButton infoButton = new JButton("Browse");
    private JRadioButton nonSNPRB = new JRadioButton("Non-SNP files");
    private JTextField nonSNPFile = new JTextField(20);
    private JButton nonSNPButton = new JButton("Browse");
    private static String[] mapSuffex = new String[]{".map", ".bim"};
    private static String[] SNPSuffex = new String[]{".adjusted", ".assoc", ".assoc.mperm", ".assoc.perm", ".cmh", ".cmh2", ".frq", ".hwe", ".lmiss", ".missing", ".missing.hap", ".linear", ".logistic", ".genotypic", ".model", ".qassoc", ".qassoc.gxe", ".tdt", ".tdt.mperm", ".tdt.perm"};
    private JRadioButton SNPRB = new JRadioButton("SNP files");
    private JTextField SNPFile = new JTextField(20);
    private JButton SNPButton = new JButton("Browse");
    private JTextField mapFile = new JTextField(20);
    private JButton mapButton = new JButton("Browse");
    private JButton ok = new JButton("OK");
    private JButton cancel = new JButton("Cancel");
    private ItemListener setFields = new ItemListener(){

        public void itemStateChanged(ItemEvent arg0) {
            OpenHapDialog.this.pedFile.setEditable(OpenHapDialog.this.pedInfoRB.isSelected());
            OpenHapDialog.this.pedButton.setEnabled(OpenHapDialog.this.pedInfoRB.isSelected());
            OpenHapDialog.this.infoFile.setEditable(OpenHapDialog.this.pedInfoRB.isSelected());
            OpenHapDialog.this.infoButton.setEnabled(OpenHapDialog.this.pedInfoRB.isSelected());
            OpenHapDialog.this.nonSNPFile.setEditable(OpenHapDialog.this.nonSNPRB.isSelected());
            OpenHapDialog.this.nonSNPButton.setEnabled(OpenHapDialog.this.nonSNPRB.isSelected());
            OpenHapDialog.this.SNPFile.setEditable(OpenHapDialog.this.SNPRB.isSelected());
            OpenHapDialog.this.SNPButton.setEnabled(OpenHapDialog.this.SNPRB.isSelected());
            OpenHapDialog.this.mapFile.setEditable(OpenHapDialog.this.SNPRB.isSelected());
            OpenHapDialog.this.mapButton.setEnabled(OpenHapDialog.this.SNPRB.isSelected());
        }
    };
    private ActionListener openHaplo = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (OpenHapDialog.this.pedInfoRB.isSelected()) {
                String[] hapOptions = RunCommand.stripAndSplit(((OpenHapDialog)OpenHapDialog.this).frame.data.getHaploAppend());
                String[] command = new String[7 + hapOptions.length];
                command[0] = "java";
                command[1] = "-jar";
                command[2] = ((OpenHapDialog)OpenHapDialog.this).frame.data.getHaploPath();
                command[3] = "-p";
                command[4] = OpenHapDialog.this.pedFile.getText();
                command[5] = "-i";
                command[6] = OpenHapDialog.this.infoFile.getText();
                if (!hapOptions[0].equals(null)) {
                    int i = 0;
                    while (i < hapOptions.length) {
                        command[i + 7] = hapOptions[i];
                        ++i;
                    }
                }
                try {
                    Process haplo = Runtime.getRuntime().exec(command);
                }
                catch (IOException e1) {
                    ((OpenHapDialog)OpenHapDialog.this).frame.messanger.createError("Error trying to open the following files in haploview [" + OpenHapDialog.this.pedFile.getText() + "], [" + OpenHapDialog.this.infoFile.getText() + "].\n", "openHaploview:OpenHapDialog.java");
                    logger.error("[openHaploview] Error trying to open the following files in haploview [" + OpenHapDialog.this.pedFile.getText() + "], [" + OpenHapDialog.this.infoFile.getText() + "].");
                }
                OpenHapDialog.this.dispose();
                return;
            }
            if (OpenHapDialog.this.nonSNPRB.isSelected()) {
                String filename = OpenHapDialog.this.nonSNPFile.getText();
                if (!new File(filename).exists()) {
                    ((OpenHapDialog)OpenHapDialog.this).frame.messanger.createError("[ " + filename + " ] does not exist, " + "can not open Haploview.\n", "openHaplo:OpenHapDialog.java");
                    logger.error("[openHaplo] [" + filename + " ] does not exist, " + "can not open Haploview.");
                    OpenHapDialog.this.dispose();
                    return;
                }
                String[] hapOptions = RunCommand.stripAndSplit(((OpenHapDialog)OpenHapDialog.this).frame.data.getHaploAppend());
                String[] command = new String[6 + hapOptions.length];
                command[0] = "java";
                command[1] = "-jar";
                command[2] = ((OpenHapDialog)OpenHapDialog.this).frame.data.getHaploPath();
                command[3] = "-plink";
                command[4] = filename;
                command[5] = "-nonSNP";
                if (!hapOptions[0].equals(null)) {
                    int i = 0;
                    while (i < hapOptions.length) {
                        command[i + 6] = hapOptions[i];
                        ++i;
                    }
                }
                try {
                    Process haplo = Runtime.getRuntime().exec(command);
                }
                catch (IOException e1) {
                    ((OpenHapDialog)OpenHapDialog.this).frame.messanger.createError("Error trying to open the following files in Haploview [" + filename + "]. \n", "openHaplo:OpenHapDialog.java");
                    logger.error("[openHaplo] Error trying to open the following files in Haploview [" + filename + "].");
                }
                OpenHapDialog.this.dispose();
                return;
            }
            if (OpenHapDialog.this.SNPRB.isSelected()) {
                String filename = OpenHapDialog.this.SNPFile.getText();
                String infile = OpenHapDialog.this.mapFile.getText();
                if (!new File(filename).exists() || !new File(infile).exists()) {
                    ((OpenHapDialog)OpenHapDialog.this).frame.messanger.createError("[ " + filename + " ] and/or [ " + infile + " ] does not exist, " + "can not open haploview.\n", "openHaplo:OpenHapDialog.java");
                    logger.error("[openHaplo][ " + filename + " ] and/or [ " + infile + " ] does not exist, " + "can not open haploview.\n");
                    OpenHapDialog.this.dispose();
                    return;
                }
                String[] hapOptions = RunCommand.stripAndSplit(((OpenHapDialog)OpenHapDialog.this).frame.data.getHaploAppend());
                String[] command = new String[7 + hapOptions.length];
                command[0] = "java";
                command[1] = "-jar";
                command[2] = ((OpenHapDialog)OpenHapDialog.this).frame.data.getHaploPath();
                command[3] = "-plink";
                command[4] = filename;
                command[5] = "-map";
                command[6] = infile;
                if (!hapOptions[0].equals(null)) {
                    int i = 0;
                    while (i < hapOptions.length) {
                        command[i + 7] = hapOptions[i];
                        ++i;
                    }
                }
                try {
                    Process haplo = Runtime.getRuntime().exec(command);
                }
                catch (IOException e1) {
                    ((OpenHapDialog)OpenHapDialog.this).frame.messanger.createError("Error trying to open the following files in haploview [ " + filename + "], [ " + infile + "]. \n", "openHaplo:OpenHapDialog.java");
                    logger.error("[openHaplo] Error trying to open the following files in haploview [ " + filename + "], [ " + infile + "].");
                }
                OpenHapDialog.this.dispose();
                return;
            }
            OpenHapDialog.this.dispose();
        }
    };

    private void populateFields(String givenOp, String filename) {
        Vector<FileInfo> inf = null;
        Vector<FileInfo> outf = null;
        if (givenOp != null) {
            OperationInfo op = this.frame.data.getOp(givenOp);
            inf = op.getInputFiles();
            outf = op.getOutputFiles();
        }
        int i = 0;
        while (i < pedSuffex.length) {
            if (filename.endsWith(pedSuffex[i])) {
                this.pedInfoRB.setSelected(true);
                this.pedFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(filename)).getAbsolutePath());
                if (givenOp != null) {
                    for (FileInfo f : inf) {
                        if (!f.toString().endsWith(".info")) continue;
                        this.infoFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(f.toString())).getAbsolutePath());
                        return;
                    }
                    for (FileInfo f : outf) {
                        if (!f.toString().endsWith(".info")) continue;
                        this.infoFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(f.toString())).getAbsolutePath());
                        return;
                    }
                }
                return;
            }
            ++i;
        }
        i = 0;
        while (i < infoSuffex.length) {
            if (filename.endsWith(infoSuffex[i])) {
                this.pedInfoRB.setSelected(true);
                this.infoFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(filename)).getAbsolutePath());
                if (givenOp != null) {
                    for (FileInfo f : inf) {
                        if (!f.toString().endsWith(".ped")) continue;
                        this.pedFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(f.toString())).getAbsolutePath());
                        return;
                    }
                    for (FileInfo f : outf) {
                        if (!f.toString().endsWith(".ped")) continue;
                        this.pedFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(f.toString())).getAbsolutePath());
                        return;
                    }
                }
                return;
            }
            ++i;
        }
        i = 0;
        while (i < SNPSuffex.length) {
            if (filename.endsWith(SNPSuffex[i])) {
                this.SNPRB.setSelected(true);
                this.SNPFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(filename)).getAbsolutePath());
                if (givenOp != null) {
                    for (FileInfo f : inf) {
                        if (!f.toString().endsWith(".map") && !f.toString().endsWith(".bim")) continue;
                        this.mapFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(f.toString())).getAbsolutePath());
                        return;
                    }
                    for (FileInfo f : outf) {
                        if (!f.toString().endsWith(".map") && !f.toString().endsWith(".bim")) continue;
                        this.mapFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(f.toString())).getAbsolutePath());
                        return;
                    }
                }
                return;
            }
            ++i;
        }
        i = 0;
        while (i < mapSuffex.length) {
            if (filename.endsWith(mapSuffex[i])) {
                this.SNPRB.setSelected(true);
                this.mapFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(filename)).getAbsolutePath());
                if (givenOp != null) {
                    int j;
                    for (FileInfo f : inf) {
                        j = 0;
                        while (j < SNPSuffex.length) {
                            if (f.toString().endsWith(SNPSuffex[j])) {
                                this.mapFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(f.toString())).getAbsolutePath());
                                return;
                            }
                            ++j;
                        }
                    }
                    for (FileInfo f : outf) {
                        j = 0;
                        while (j < SNPSuffex.length) {
                            if (f.toString().endsWith(SNPSuffex[j])) {
                                this.mapFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(f.toString())).getAbsolutePath());
                                return;
                            }
                            ++j;
                        }
                    }
                }
                return;
            }
            ++i;
        }
        this.nonSNPRB.setSelected(true);
        this.nonSNPFile.setText(new File(this.frame.data.getLocalFolder(), FileInfo.fileName(filename)).getAbsolutePath());
    }

    void createPanel() {
        this.pedButton.addActionListener(new myActionListener(this.pedFile, pedSuffex, "PED file"));
        this.infoButton.addActionListener(new myActionListener(this.infoFile, infoSuffex, "INFO file"));
        this.nonSNPButton.addActionListener(new myActionListener(this.nonSNPFile, null, null));
        this.mapButton.addActionListener(new myActionListener(this.mapFile, mapSuffex, "MAP file"));
        this.SNPButton.addActionListener(new myActionListener(this.SNPFile, SNPSuffex, "snp files"));
        this.pedInfoRB.addItemListener(this.setFields);
        this.nonSNPRB.addItemListener(this.setFields);
        this.SNPRB.addItemListener(this.setFields);
        ButtonGroup pickOne = new ButtonGroup();
        pickOne.add(this.pedInfoRB);
        pickOne.add(this.nonSNPRB);
        pickOne.add(this.SNPRB);
        JPanel buttonPane = new JPanel();
        buttonPane.add(this.ok);
        this.ok.addActionListener(this.openHaplo);
        buttonPane.add(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OpenHapDialog.this.dispose();
            }
        });
        Container mainPane = this.getContentPane();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        mainPane.add((Component)this.pedInfoRB, c);
        c.gridx = 1;
        c.weightx = 1.0;
        mainPane.add((Component)this.pedFile, c);
        c.gridx = 2;
        c.weightx = 0.0;
        mainPane.add((Component)this.pedButton, c);
        c.gridx = 3;
        mainPane.add((Component)new JLabel("(-info)"), c);
        c.gridx = 4;
        c.weightx = 1.0;
        mainPane.add((Component)this.infoFile, c);
        c.gridx = 5;
        c.weightx = 0.0;
        mainPane.add((Component)this.infoButton, c);
        c.gridy = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        mainPane.add((Component)this.nonSNPRB, c);
        c.gridx = 1;
        c.weightx = 1.0;
        mainPane.add((Component)this.nonSNPFile, c);
        c.gridx = 2;
        c.weightx = 0.0;
        mainPane.add((Component)this.nonSNPButton, c);
        c.gridy = 2;
        c.gridx = 0;
        c.weightx = 0.0;
        mainPane.add((Component)this.SNPRB, c);
        c.gridx = 1;
        c.weightx = 1.0;
        mainPane.add((Component)this.SNPFile, c);
        c.gridx = 2;
        c.weightx = 0.0;
        mainPane.add((Component)this.SNPButton, c);
        c.gridx = 3;
        mainPane.add((Component)new JLabel("(-map)"), c);
        c.gridx = 4;
        c.weightx = 1.0;
        mainPane.add((Component)this.mapFile, c);
        c.gridx = 5;
        c.weightx = 0.0;
        mainPane.add((Component)this.mapButton, c);
        c.gridy = 3;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 6;
        mainPane.add((Component)buttonPane, c);
    }

    public OpenHapDialog(GPLINK mf, String givenOp, String givenFile) {
        super((Frame)mf, "Open File in Haploview");
        this.frame = mf;
        this.createPanel();
        this.populateFields(givenOp, givenFile);
        this.pack();
        this.setVisible(true);
    }

    private class myActionListener
    implements ActionListener {
        private GCFileChooser chooser;
        private JTextField text;
        private String[] suffix;
        private String disc;

        public myActionListener(JTextField myText, String[] mySuffix, String myDisc) {
            this.text = myText;
            this.suffix = mySuffix;
            this.disc = myDisc;
        }

        public void actionPerformed(ActionEvent e) {
            FileFilter filter = this.suffix != null && this.disc != null ? new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String[] stringArray = myActionListener.this.suffix;
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        String s = stringArray[n];
                        if (f.getName().endsWith(s)) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }

                public String getDescription() {
                    return myActionListener.this.disc;
                }
            } : null;
            this.chooser = new GCFileChooser(OpenHapDialog.this.frame, filter, true, false, null, ((OpenHapDialog)OpenHapDialog.this).frame.data.getLocalFolder().getAbsolutePath());
            this.chooser.addFileChoosenListener(new GCFileChooser.FileChoosenListener(){

                public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                    myActionListener.this.text.setText(((myActionListener)myActionListener.this).chooser.fileName);
                }
            });
            this.chooser.showChooser();
        }
    }
}

