/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

public enum QueryFilterOperators {
    EQUAL(0, "="),
    LIKE(1, "LIKE"),
    IN(2, "IN"),
    IS_NULL(3, "IS NULL"),
    LESS(4, "<"),
    LESS_EQUAL(5, "<="),
    MORE(6, ">"),
    MORE_EQUAL(7, ">="),
    NOT_EQUAL(8, "<>"),
    NOT_IN(9, "NOT IN"),
    IS_NOT_NULL(10, "IS NOT NULL");

    private int _index;
    private String _toString;

    private QueryFilterOperators(int index, String toString) {
        this._index = index;
        this._toString = toString;
    }

    public int getIndex() {
        return this._index;
    }

    public String toString() {
        return this._toString;
    }

    public boolean isNoArgOperator() {
        return QueryFilterOperators.isNoArgOperator(this);
    }

    public static boolean isNoArgOperator(QueryFilterOperators operator) {
        return IS_NOT_NULL == operator || IS_NULL == operator;
    }

    public static QueryFilterOperators getForIndex(int operatorIndex) {
        for (QueryFilterOperators queryFilterOperator : QueryFilterOperators.values()) {
            if (queryFilterOperator._index != operatorIndex) continue;
            return queryFilterOperator;
        }
        throw new IllegalArgumentException("Unkonwn operator index " + operatorIndex);
    }

    public String getSQL() {
        return this._toString;
    }

    public boolean isSingleValued() {
        return IN != this && NOT_IN != this;
    }
}

