/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.util.NapkinUtil;
import net.sourceforge.napkinlaf.util.RandomXY;

public class DrawnCubicLineGenerator
extends AbstractDrawnGenerator {
    private final RandomXY left = new RandomXY(10.0, 4.0, -0.7, 1.5);
    private final RandomXY right = new RandomXY(20.0, 8.0, -1.3, 2.0);
    public static final DrawnCubicLineGenerator INSTANCE = new DrawnCubicLineGenerator();
    private static final Logger logger = Logger.getLogger(DrawnCubicLineGenerator.class.getName());

    public Shape generate(AffineTransform matrix) {
        Shape result;
        Point2D leftAt = this.left.generate();
        Point2D rightAt = this.right.generate();
        double lx = NapkinUtil.leftRight(leftAt.getX(), true);
        double ly = leftAt.getY();
        double rx = NapkinUtil.leftRight(rightAt.getX(), false);
        double ry = rightAt.getY();
        double[] coords = new double[]{0.0, 0.0, lx, ly, rx, ry, 100.0, 0.0};
        if (matrix != null) {
            matrix.transform(coords, 0, coords, 0, 4);
        }
        CubicCurve2D.Double line = new CubicCurve2D.Double(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], coords[6], coords[7]);
        if (logger.isLoggable(Level.FINE)) {
            GeneralPath shape = new GeneralPath(new Rectangle2D.Double(coords[0] - 2.0, coords[1] - 2.0, 4.0, 4.0));
            shape.append(line, false);
            shape.append(new Line2D.Double(coords[6] - 2.0, coords[7] - 2.0, coords[6] + 2.0, coords[7] + 2.0), false);
            shape.append(new Line2D.Double(coords[6] + 2.0, coords[7] - 2.0, coords[6] - 2.0, coords[7] + 2.0), false);
            result = shape;
        } else {
            result = line;
        }
        return result;
    }

    public RandomXY getLeft() {
        return this.left;
    }

    public RandomXY getRight() {
        return this.right;
    }
}

