/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.settings;

import com.l2fprod.common.swing.JFontChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmeld.JMeld;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.settings.EditorSettingsForm;
import org.jmeld.ui.util.EmptyIcon;
import org.jmeld.ui.util.FontUtil;
import org.jmeld.ui.util.LookAndFeelManager;
import org.jmeld.util.CharsetDetector;
import org.jmeld.util.Ignore;
import org.jmeld.util.conf.ConfigurationListenerIF;

public class EditorSettingsPanel
extends EditorSettingsForm
implements ConfigurationListenerIF {
    private static JDialog colorDialog;
    private static JColorChooser colorChooser;
    private boolean originalAntialias = this.getEditorSettings().isAntialiasEnabled();

    public EditorSettingsPanel() {
        this.initConfiguration();
        this.init();
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    private void init() {
        this.ignoreWhitespaceAtBeginCheckBox.addActionListener(this.getIgnoreWhitespaceAtBeginAction());
        this.ignoreWhitespaceInBetweenCheckBox.addActionListener(this.getIgnoreWhitespaceInBetweenAction());
        this.ignoreWhitespaceAtEndCheckBox.addActionListener(this.getIgnoreWhitespaceAtEndAction());
        this.ignoreEOLCheckBox.addActionListener(this.getIgnoreEOLAction());
        this.ignoreBlankLinesCheckBox.addActionListener(this.getIgnoreBlankLinesAction());
        this.ignoreCaseCheckBox.addActionListener(this.getIgnoreCaseAction());
        this.leftsideReadonlyCheckBox.addActionListener(this.getLeftsideReadonlyAction());
        this.rightsideReadonlyCheckBox.addActionListener(this.getRightsideReadonlyAction());
        this.antialiasCheckBox.addActionListener(this.getAntialiasAction());
        this.tabSizeSpinner.addChangeListener(this.getTabSizeChangeListener());
        this.showLineNumbersCheckBox.addActionListener(this.getShowLineNumbersAction());
        this.lookAndFeelComboBox.setModel(this.getLookAndFeelModel());
        this.lookAndFeelComboBox.setSelectedItem(LookAndFeelManager.getInstance().getInstalledLookAndFeelName());
        this.lookAndFeelComboBox.addActionListener(this.getLookAndFeelAction());
        this.colorAddedButton.addActionListener(this.getColorAddedAction());
        this.colorDeletedButton.addActionListener(this.getColorDeletedAction());
        this.colorChangedButton.addActionListener(this.getColorChangedAction());
        this.restoreOriginalColorsButton.addActionListener(this.getRestoreOriginalColorsAction());
        this.defaultFontRadioButton.addActionListener(this.getDefaultFontAction());
        this.customFontRadioButton.addActionListener(this.getCustomFontAction());
        this.fontChooserButton.addActionListener(this.getFontChooserAction());
        this.defaultEncodingRadioButton.setText(this.defaultEncodingRadioButton.getText() + " (" + CharsetDetector.getInstance().getDefaultCharset() + ")");
        this.defaultEncodingRadioButton.addActionListener(this.getDefaultEncodingAction());
        this.detectEncodingRadioButton.addActionListener(this.getDetectEncodingAction());
        this.specificEncodingRadioButton.addActionListener(this.getSpecificEncodingAction());
        this.specificEncodingComboBox.setModel(new DefaultComboBoxModel<Object>(CharsetDetector.getInstance().getCharsetNameList().toArray()));
        this.specificEncodingComboBox.setSelectedItem(this.getEditorSettings().getSpecificFileEncodingName());
        this.specificEncodingComboBox.addActionListener(this.getSpecificEncodingNameAction());
        this.toolbarButtonIconComboBox.setModel(this.getToolbarButtonIconModel());
        this.toolbarButtonIconComboBox.setSelectedItem((Object)this.getEditorSettings().getToolbarButtonIcon());
        this.toolbarButtonIconComboBox.addActionListener(this.getToolbarButtonIconAction());
        this.toolbarButtonTextEnabledCheckBox.addActionListener(this.getToolbarButtonTextEnabledAction());
    }

    private ChangeListener getTabSizeChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setTabSize((Integer)EditorSettingsPanel.this.tabSizeSpinner.getValue());
            }
        };
    }

    private ActionListener getColorAddedAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Color color = EditorSettingsPanel.this.chooseColor(EditorSettingsPanel.this.getEditorSettings().getAddedColor());
                if (color != null) {
                    EditorSettingsPanel.this.getEditorSettings().setAddedColor(color);
                }
            }
        };
    }

    private ActionListener getColorDeletedAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Color color = EditorSettingsPanel.this.chooseColor(EditorSettingsPanel.this.getEditorSettings().getDeletedColor());
                if (color != null) {
                    EditorSettingsPanel.this.getEditorSettings().setDeletedColor(color);
                }
            }
        };
    }

    private ActionListener getColorChangedAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Color color = EditorSettingsPanel.this.chooseColor(EditorSettingsPanel.this.getEditorSettings().getChangedColor());
                if (color != null) {
                    EditorSettingsPanel.this.getEditorSettings().setChangedColor(color);
                }
            }
        };
    }

    private ActionListener getShowLineNumbersAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setShowLineNumbers(EditorSettingsPanel.this.showLineNumbersCheckBox.isSelected());
            }
        };
    }

    private ActionListener getIgnoreWhitespaceAtBeginAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setIgnoreWhitespaceAtBegin(EditorSettingsPanel.this.ignoreWhitespaceAtBeginCheckBox.isSelected());
            }
        };
    }

    private ActionListener getIgnoreWhitespaceInBetweenAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setIgnoreWhitespaceInBetween(EditorSettingsPanel.this.ignoreWhitespaceInBetweenCheckBox.isSelected());
            }
        };
    }

    private ActionListener getIgnoreWhitespaceAtEndAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setIgnoreWhitespaceAtEnd(EditorSettingsPanel.this.ignoreWhitespaceAtEndCheckBox.isSelected());
            }
        };
    }

    private ActionListener getIgnoreEOLAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setIgnoreEOL(EditorSettingsPanel.this.ignoreEOLCheckBox.isSelected());
            }
        };
    }

    private ActionListener getIgnoreBlankLinesAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setIgnoreBlankLines(EditorSettingsPanel.this.ignoreBlankLinesCheckBox.isSelected());
            }
        };
    }

    private ActionListener getIgnoreCaseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setIgnoreCase(EditorSettingsPanel.this.ignoreCaseCheckBox.isSelected());
            }
        };
    }

    private ActionListener getLeftsideReadonlyAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setLeftsideReadonly(EditorSettingsPanel.this.leftsideReadonlyCheckBox.isSelected());
            }
        };
    }

    private ActionListener getRightsideReadonlyAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setRightsideReadonly(EditorSettingsPanel.this.rightsideReadonlyCheckBox.isSelected());
            }
        };
    }

    private ActionListener getAntialiasAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().enableAntialias(EditorSettingsPanel.this.antialiasCheckBox.isSelected());
            }
        };
    }

    private ActionListener getRestoreOriginalColorsAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().restoreColors();
            }
        };
    }

    private ActionListener getDefaultEncodingAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setDefaultFileEncodingEnabled(true);
                EditorSettingsPanel.this.getEditorSettings().setDetectFileEncodingEnabled(false);
                EditorSettingsPanel.this.getEditorSettings().setSpecificFileEncodingEnabled(false);
            }
        };
    }

    private ActionListener getDetectEncodingAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setDefaultFileEncodingEnabled(false);
                EditorSettingsPanel.this.getEditorSettings().setDetectFileEncodingEnabled(true);
                EditorSettingsPanel.this.getEditorSettings().setSpecificFileEncodingEnabled(false);
            }
        };
    }

    private ActionListener getSpecificEncodingAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setDefaultFileEncodingEnabled(false);
                EditorSettingsPanel.this.getEditorSettings().setDetectFileEncodingEnabled(false);
                EditorSettingsPanel.this.getEditorSettings().setSpecificFileEncodingEnabled(true);
            }
        };
    }

    private ActionListener getSpecificEncodingNameAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setSpecificFileEncodingName((String)EditorSettingsPanel.this.specificEncodingComboBox.getSelectedItem());
            }
        };
    }

    private ActionListener getLookAndFeelAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setLookAndFeelName((String)EditorSettingsPanel.this.lookAndFeelComboBox.getSelectedItem());
                LookAndFeelManager.getInstance().install();
            }
        };
    }

    private ActionListener getToolbarButtonIconAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setToolbarButtonIcon((EditorSettings.ToolbarButtonIcon)((Object)EditorSettingsPanel.this.toolbarButtonIconComboBox.getSelectedItem()));
                JMeld.getJMeldPanel().addToolBar();
            }
        };
    }

    private ActionListener getToolbarButtonTextEnabledAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setToolbarButtonTextEnabled(EditorSettingsPanel.this.toolbarButtonTextEnabledCheckBox.isSelected());
                JMeld.getJMeldPanel().addToolBar();
            }
        };
    }

    private ActionListener getDefaultFontAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().enableCustomFont(!EditorSettingsPanel.this.defaultFontRadioButton.isSelected());
            }
        };
    }

    private ActionListener getCustomFontAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().enableCustomFont(EditorSettingsPanel.this.customFontRadioButton.isSelected());
            }
        };
    }

    private ActionListener getFontChooserAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Font font = EditorSettingsPanel.this.chooseFont(EditorSettingsPanel.this.getEditorFont());
                if (font != null) {
                    EditorSettingsPanel.this.getEditorSettings().setFont(font);
                }
            }
        };
    }

    private Color chooseColor(Color initialColor) {
        if (colorDialog == null) {
            colorChooser = new JColorChooser(initialColor);
            colorDialog = JColorChooser.createDialog(null, "Choose color", true, colorChooser, null, null);
        }
        colorChooser.setColor(initialColor);
        colorDialog.setVisible(true);
        return colorChooser.getColor();
    }

    private Font chooseFont(Font initialFont) {
        JFontChooser fontChooser = new JFontChooser();
        fontChooser.setSelectedFont(initialFont);
        return fontChooser.showFontDialog((Component)this, "");
    }

    private ComboBoxModel getLookAndFeelModel() {
        return new DefaultComboBoxModel<Object>(LookAndFeelManager.getInstance().getInstalledLookAndFeels().toArray());
    }

    private ComboBoxModel getToolbarButtonIconModel() {
        return new DefaultComboBoxModel<EditorSettings.ToolbarButtonIcon>(this.getEditorSettings().getToolbarButtonIcons());
    }

    public void configurationChanged() {
        this.initConfiguration();
    }

    private void initConfiguration() {
        EditorSettings settings = this.getEditorSettings();
        Ignore ignore = settings.getIgnore();
        this.colorAddedButton.setIcon(new EmptyIcon(settings.getAddedColor(), 20, 20));
        this.colorAddedButton.setText("");
        this.colorDeletedButton.setIcon(new EmptyIcon(settings.getDeletedColor(), 20, 20));
        this.colorDeletedButton.setText("");
        this.colorChangedButton.setIcon(new EmptyIcon(settings.getChangedColor(), 20, 20));
        this.colorChangedButton.setText("");
        this.showLineNumbersCheckBox.setSelected(settings.getShowLineNumbers());
        this.ignoreWhitespaceAtBeginCheckBox.setSelected(ignore.ignoreWhitespaceAtBegin);
        this.ignoreWhitespaceInBetweenCheckBox.setSelected(ignore.ignoreWhitespaceInBetween);
        this.ignoreWhitespaceAtEndCheckBox.setSelected(ignore.ignoreWhitespaceAtEnd);
        this.ignoreEOLCheckBox.setSelected(ignore.ignoreEOL);
        this.ignoreBlankLinesCheckBox.setSelected(ignore.ignoreBlankLines);
        this.ignoreCaseCheckBox.setSelected(ignore.ignoreCase);
        this.leftsideReadonlyCheckBox.setSelected(settings.getLeftsideReadonly());
        this.rightsideReadonlyCheckBox.setSelected(settings.getRightsideReadonly());
        this.antialiasCheckBox.setSelected(settings.isAntialiasEnabled());
        if (this.originalAntialias != settings.isAntialiasEnabled()) {
            this.antialiasCheckBox.setText("antialias on (NEED A RESTART)");
        } else {
            this.antialiasCheckBox.setText("antialias on");
        }
        this.tabSizeSpinner.setValue(settings.getTabSize());
        Font font = this.getEditorFont();
        this.fontChooserButton.setFont(font);
        this.fontChooserButton.setText(font.getName() + " (" + font.getSize() + ")");
        this.defaultFontRadioButton.setSelected(!settings.isCustomFontEnabled());
        this.customFontRadioButton.setSelected(settings.isCustomFontEnabled());
        this.defaultEncodingRadioButton.setSelected(settings.getDefaultFileEncodingEnabled());
        this.detectEncodingRadioButton.setSelected(settings.getDetectFileEncodingEnabled());
        this.specificEncodingRadioButton.setSelected(settings.getSpecificFileEncodingEnabled());
        this.toolbarButtonIconComboBox.setSelectedItem((Object)this.getEditorSettings().getToolbarButtonIcon());
        this.toolbarButtonTextEnabledCheckBox.setSelected(this.getEditorSettings().isToolbarButtonTextEnabled());
        this.revalidate();
    }

    private EditorSettings getEditorSettings() {
        return JMeldSettings.getInstance().getEditor();
    }

    private Font getEditorFont() {
        Font font = this.getEditorSettings().getFont();
        font = font == null ? FontUtil.defaultTextAreaFont : font;
        return font;
    }
}

