/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class OverviewFrame
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OverviewFrame.class);
    private static final String PREF_KEY_OVERVIEW_FRAME_WIDTH = "Squirrel.overview.FrameWidth";
    private static final String PREF_KEY_OVERVIEW_FRAME_HIGHT = "Squirrel.overview.FrameHight";
    private JCheckBox _chkOnTop;

    public OverviewFrame(DataSetViewerTablePanel simpleTable, IApplication app, Window parent) {
        super(s_stringMgr.getString("OverviewFrame.title"), true, true, true, true, app, parent);
        this.setDefaultCloseOperation(2);
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        if (app.getDesktopStyle().supportsLayers()) {
            JPanel pnlButtons = new JPanel(new GridBagLayout());
            this._chkOnTop = new JCheckBox(s_stringMgr.getString("OverviewFrame.stayOnTop"));
            GridBagConstraints gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
            pnlButtons.add((Component)this._chkOnTop, gbc);
            this._chkOnTop.setSelected(true);
            this._chkOnTop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OverviewFrame.this.onStayOnTopChanged();
                }
            });
            gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
            pnlButtons.add((Component)new JPanel(), gbc);
            cont.add((Component)pnlButtons, "North");
        }
        cont.add((Component)new JScrollPane(simpleTable.getComponent()), "Center");
        int width = Preferences.userRoot().getInt(PREF_KEY_OVERVIEW_FRAME_WIDTH, 300);
        int hight = Preferences.userRoot().getInt(PREF_KEY_OVERVIEW_FRAME_HIGHT, 300);
        this.setSize(new Dimension(width, hight));
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetClosing(WidgetEvent evt) {
                OverviewFrame.this.onWidgetClosing();
            }
        });
    }

    private void onWidgetClosing() {
        Dimension size = this.getSize();
        Preferences.userRoot().putInt(PREF_KEY_OVERVIEW_FRAME_WIDTH, size.width);
        Preferences.userRoot().putInt(PREF_KEY_OVERVIEW_FRAME_HIGHT, size.height);
    }

    private void onStayOnTopChanged() {
        if (this._chkOnTop.isSelected()) {
            this.setLayer((int)JLayeredPane.PALETTE_LAYER);
        } else {
            this.setLayer((int)JLayeredPane.DEFAULT_LAYER);
        }
        this.toFront();
    }
}

