//---------------------------------------------------------------------------
// Copyright (C) 2000 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
//  1wsensor.h - Include file for 1-wire sensor scripts.  Contains
//               script step contants and scripts.
//
//  Version: 2.00
//


#ifndef WSENSOR_TYPES

#define WSENSOR_TYPES

// defines
#define WRITE_FUNCTION  1
#define READ_FUNCTION   0

#include <stdlib.h>

// Typedefs
#ifndef OW_UCHAR
   #define OW_UCHAR
   typedef unsigned char  uchar;
   #ifdef WIN32
      typedef unsigned short ushort;
      typedef unsigned long  ulong;
   #endif
#endif

// structure to hold each state in the StateMachine
typedef struct
{
   int  Step;
   char StepDescription[50];
} Script;

// step constants
enum { ST_SETUP=0, ST_EE_RECALL, ST_DELAY_100MS, ST_TEMP_CONV_1820,
       ST_READ_TEMP_1820, ST_FINISH, ST_GET_SESSION, ST_REL_SESSION,
       ST_VERIFY, ST_SET_BRANCH_2406, ST_VERIFY_SWITCH, ST_READ_COUNT_2423,   
       ST_READ_TAG_NEXT, ST_READ_LEVEL_2406, ST_READ_ACTIVITY_2406,
       ST_SET_BRANCH_2409, ST_READ_LEVEL_2409, ST_READ_ACTIVITY_2409 };

// status contants
enum { STATUS_STEP_COMPLETE, STATUS_COMPLETE, STATUS_INPROGRESS,
       STATUS_ERROR_HALT, STATUS_ERROR_TRANSIENT };


#endif

#ifdef SENSOR_SCRIPTS

// Verify 1-Wire Net is OK
Script Verify1Wire[] = 
    {{ ST_GET_SESSION,  "Acquire a session" }, 
     { ST_SETUP,        "Verify 1-Wire"},
     { ST_REL_SESSION,  "Release the session" },
     { ST_FINISH,       "Finished"}}; 

// Find devices and read Tag
Script TagScan[] = 
    {{ ST_GET_SESSION,  "Acquire a session" }, 
     { ST_READ_TAG_NEXT,"Read tag and next device" },
     { ST_REL_SESSION,  "Release the session" },
     { ST_FINISH,       "Finished"}}; 

// Read DS1820 using MIB information
Script ReadDS1820[] = 
    {{ ST_GET_SESSION,     "Acquire a session" }, 
     { ST_VERIFY,          "Select and verify device" }, 
     { ST_EE_RECALL,       "Recall EE calibration" },
     { ST_READ_TEMP_1820,  "Read the temperature" },
     { ST_REL_SESSION,     "Release the session" },
     { ST_FINISH,          "Finished" }}; 

// Set the state of a branch using MIB information
Script SetBranch2406[] = 
    {{ ST_GET_SESSION,     "Acquire a session" }, 
     { ST_VERIFY,          "Select and verify device" }, 
     { ST_SET_BRANCH_2406, "Set the branch 2406 state" },
     { ST_REL_SESSION,     "Release the session" },
     { ST_FINISH,          "Finished" }}; 

// Set the state of a branch using MIB information
Script SetBranch2409[] = 
    {{ ST_GET_SESSION,     "Acquire a session" }, 
     { ST_VERIFY,          "Select and verify device" }, 
     { ST_SET_BRANCH_2409, "Set the branch 2409 state" },
     { ST_REL_SESSION,     "Release the session" },
     { ST_FINISH,          "Finished" }}; 

// Read a level (High/Low) using MIB information
Script ReadLevel2406[] = 
    {{ ST_GET_SESSION,     "Acquire a session" }, 
     { ST_VERIFY,          "Select and verify device" }, 
     { ST_SET_BRANCH_2406, "Set the switch state" },
     { ST_READ_LEVEL_2406, "Read the level state" },
     { ST_REL_SESSION,     "Release the session" },
     { ST_FINISH,          "Finished" }}; 

// Read a level (High/Low) using MIB information
Script ReadLevel2409[] = 
    {{ ST_GET_SESSION,     "Acquire a session" }, 
     { ST_VERIFY,          "Select and verify device" }, 
     { ST_SET_BRANCH_2409, "Set the switch state" },
     { ST_READ_LEVEL_2409, "Read the level state" },
     { ST_REL_SESSION,     "Release the session" },
     { ST_FINISH,          "Finished" }}; 

// Read a activity (YES/NO) using MIB information
Script ReadActivity2406[] = 
    {{ ST_GET_SESSION,        "Acquire a session" }, 
     { ST_VERIFY,             "Select and verify device" }, 
     { ST_READ_ACTIVITY_2406, "Read the activity state" },
     { ST_REL_SESSION,        "Release the session" },
     { ST_FINISH,             "Finished" }}; 

// Read a activity (YES/NO) using MIB information
Script ReadActivity2409[] = 
    {{ ST_GET_SESSION,        "Acquire a session" }, 
     { ST_VERIFY,             "Select and verify device" }, 
     { ST_READ_ACTIVITY_2409, "Read the activity state" },
     { ST_REL_SESSION,        "Release the session" },
     { ST_FINISH,             "Finished" }}; 

// Read an ordered list of rom switches using MIB information
Script ReadOrderedSwitch[] = 
    {{ ST_GET_SESSION,  "Acquire a session" }, 
     { ST_VERIFY_SWITCH,"Select and verify the state of a rom switch" }, 
     { ST_REL_SESSION,  "Release the session" },
     { ST_FINISH,       "Finished" }}; 

// Read counter velocity using MIB information
Script ReadCounterVelocity2423[] = 
    {{ ST_GET_SESSION,     "Acquire a session" }, 
     { ST_VERIFY,          "Select and verify device" }, 
     { ST_READ_COUNT_2423, "Read a counter" },
     { ST_DELAY_100MS,     "Delay 100ms" },
     { ST_DELAY_100MS,     "Delay 100ms" },
     { ST_DELAY_100MS,     "Delay 100ms" },
     { ST_DELAY_100MS,     "Delay 100ms" },
     { ST_DELAY_100MS,     "Delay 100ms" },
     { ST_READ_COUNT_2423, "Read a counter" },
     { ST_REL_SESSION,     "Release the session" },
     { ST_FINISH,          "Finished" }}; 

// Read counter velocity using MIB information
Script ReadCounter2423[] = 
    {{ ST_GET_SESSION,     "Acquire a session" }, 
     { ST_VERIFY,          "Select and verify device" }, 
     { ST_READ_COUNT_2423, "Read a counter" },
     { ST_REL_SESSION,     "Release the session" },
     { ST_FINISH,          "Finished" }}; 

#else

extern Script TagScan[];
extern Script Verify1Wire[];
extern Script ReadDS1820[];
extern Script SetBranch2406[];
extern Script SetBranch2409[];
extern Script ReadLevel2406[];
extern Script ReadLevel2409[];
extern Script ReadActivity2406[];
extern Script ReadActivity2409[];
extern Script ReadOrderedSwitch[];
extern Script ReadCounterVelocity2423[];
extern Script ReadCounter2423[];

#endif



