//---------------------------------------------------------------------------
// Copyright (C) 2000 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
//  tstowe.c - Test application to test the EPROM programming functions.
//
//  Version: 2.00
//
//  History: 1.01 -> 1.02  Changed to generic OpenCOM/CloseCOM for easier 
//                         use with other platforms.  
//           1.02 -> 1.03  Removed caps in #includes for Linux capatibility
//                         Changed to use Acquire/Release 1-Wire Net functions
//           1.03 -> 2.00  Reorganization of Public Domain Kit 
//

#include <stdio.h>
#include <stdlib.h>
#include "ownet.h"

// external One Wire functions to test
extern int  owTouchByte(int,int);
extern int  owFirst(int,int,int);
extern int  owNext(int,int,int);
extern void owSerialNum(int,uchar *, int);
extern void owFamilySearchSetup(int,int);
extern void owSkipFamily(int);
extern int  owAccess(int);
extern int  owOverdriveAccess(int);
extern int  owVerify(int,int);
extern int  owBlock(int,int,uchar *,int);
extern int  owReadPacketStd(int,int,int,uchar *);
extern int  owWritePacketStd(int,int,uchar *,int,int,int);   
extern int  owSpeed(int,int);
extern int  owLevel(int,int);
extern int  MLanReadFile(uchar *, uchar *);
extern int  MLanFormatWriteFile(uchar *, int, uchar *);
extern int  owProgramPulse(int);
extern int  MLanProgramByte(int,int,int,int,int);
extern int  owAcquire(int,char *,char *);
extern void owRelease(int,char *);

// local funcitons
void PrintSerialNum(int);

//----------------------------------------------------------------------
//  Main Test
//
int main(short argc, char **argv)
{
   int PortNum=1,rslt,i,testcnt=0,length,pg;
   uchar tran_buffer[2000];
   char return_msg[128];
  
   // check for required port name
   if (argc != 2)
   {
      printf("1-Wire Net name required on command line!\n"
             " (example: \"COM1\" (Win32 DS2480),\"/dev/cua0\" "
             "(Linux DS2480),\"1\" (Win32 TMEX)\n");
      exit(1);
   }

   // attempt to acquire the 1-Wire Net
   if (!owAcquire(PortNum,argv[1],return_msg))
   {  
      printf("%s",return_msg);
      exit(1);
   }

   // success
   printf("%s",return_msg);

   //----------------------------------------
   // Introduction
   printf("\n/---------------------------------------------\n");
   printf("  The following is a test excersize of the\n"
          "  1-Wire Net public domain library Version 2.00.\n\n"
          "  This test was run using a 12 Volt program capable \n"
          "  adapter and 1 DS1985 and 1 DS1982\n\n");

   //----------------------------------------
   // Find the DS1982 on the 1-Wire Net
   printf("\n/---------------------------------------------\n");
   printf("TEST%d: Find the DS1982 on the 1-Wire Net\n",testcnt++);

   // find the first device 
   rslt = owFirst(PortNum,TRUE, FALSE);
   // print the Serial Number of the device just found
   PrintSerialNum(PortNum);

   //----------------------------------------
   // Write a packet with One Wire WritePacketStd to DS1982 
   printf("\n/---------------------------------------------\n");
   printf("TEST%d: Write a packet with owWritePacketStd to DS1982\n",testcnt++);
     
   // set the page to write
   pg = 3; 

   for (i = 0; i < 29; i++)
      tran_buffer[i] = (uchar)i;

   printf("Write EPROM page %d: %d\n",pg,owWritePacketStd(PortNum,pg,tran_buffer,29,TRUE,0));

   for (i = 0; i < 29; i++)
      tran_buffer[i] = 0;

   length = owReadPacketStd(PortNum,TRUE,pg,tran_buffer);

   printf("Read page %d: %d\n",pg,length);

   for (i = 0; i < length; i++)
      printf("%02X",tran_buffer[i]);
   printf("\n");

   //----------------------------------------
   // Find the DS1985 on the 1-Wire Net
   printf("\n/---------------------------------------------\n");
   printf("TEST%d: Find the DS1985 on the 1-Wire Net\n",testcnt++);

   // find the first device 
   rslt = owNext(PortNum,TRUE, FALSE);
   // print the Serial Number of the device just found
   PrintSerialNum(PortNum);

   //----------------------------------------
   // Write a packet with One Wire PacketStd to DS1985 
   printf("\n/---------------------------------------------\n");
   printf("TEST%d: Write a packet with owWritePacketStd to DS1985\n",testcnt++);
      
   // set the page to write
   pg = 62; 

   for (i = 0; i < 29; i++)
      tran_buffer[i] = (uchar)i;

   printf("Write EPROM page %d: %d\n",pg,owWritePacketStd(PortNum,pg,tran_buffer,29,TRUE,1));

   for (i = 0; i < 29; i++)
      tran_buffer[i] = 0;

   length = owReadPacketStd(PortNum,TRUE,pg,tran_buffer);

   printf("Read page %d: %d\n",pg,length);

   for (i = 0; i < length; i++)
      printf("%02X",tran_buffer[i]);
   printf("\n");

   // release the 1-Wire Net
   owRelease(PortNum,return_msg);
   printf("%s",return_msg);
   exit(0);

   return 0;
}

//----------------------------------------------------------------------
//  Read and print the Serial Number.
//
void PrintSerialNum(int portnum)
{
   uchar TempSerialNumber[8];
   int i;

   owSerialNum(portnum,TempSerialNumber,TRUE);
   for (i = 7; i >= 0; i--)
      printf("%02X",TempSerialNumber[i]);
   printf("\n");
}
